<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
?>

<?php if (isset($_GET['settings-updated'])) {
    $qid = trim(get_option(YAOLA_PRODUCT_ID));
    if ($qid == '') { ?>
        <div id="message" class="notice notice-warning is-dismissible">
            <p><strong><?php _e('您未填写应用ID, 51LA网站统计将无法使用!', YAOLA_PRODUCT); ?></strong></p>
        </div>
    <?php } else { ?>
        <div id="message" class="notice notice-success is-dismissible">
            <p><strong>保存成功，
                    <a href="<?php echo esc_attr(trim(get_option(YAOLA_PRODUCT_VERSION))) == 'v6' ? 'https://v6.51.la/user/application' : 'https://web.51.la/user/site/index';?>" target="_blank">点此查看数据报表</a>
                </strong></p>
        </div>
    <?php }
} ?>

<div id="business-info-wrap" class="wrap"
     style="width: 710px; font-size: 13px; background: #fff; border: 1px solid #ccc; padding: 15px 20px;">
    <div class="wp-header">
        <a href="https://v6.51.la?cc=YWEGU5" target="_blank"
           style="display: inline-block;width: 100px;height: 50px;">
            <img src="<?php echo plugins_url('../static/logo.svg', __FILE__); ?>"
                 style="width: 100px;"></a>
    </div>
    <form method="post" action="options.php">
        <?php settings_fields(YAOLA_PRODUCT);
        do_settings_sections(YAOLA_PRODUCT_ID); ?>
        <div>
            <p style="color: #333"><b>51LA网站统计 WordPress 版本插件，快速引入到您的网站或博客中，用于统计网站访客、来路、事件分析和搜索引擎蜘蛛分析等，插件直接引入，支持 <a href="https://web.51.la" target="_blank">v5</a> / <a href="https://v6.51.la?cc=YWEGU5" target="_blank">v6</a> 新旧版本网站统计，无需修改主题文件。</b></p>
            <div>
                <a class="info-button" target="_blank" href="<?php echo esc_attr(trim(get_option(YAOLA_PRODUCT_VERSION))) == 'v6' ? 'https://v6.51.la/user/application' : 'https://web.51.la/user/site/index';?>">查看数据报表</a>
            </div>
            <h3>选择统计版本：<span style="color: #999; font-size: 12px;">(请选择您需要使用的统计版本)</span></h3>
            <input id = 'v5' type="radio" name="<?php echo YAOLA_PRODUCT_VERSION; ?>" value="v5" <?php echo esc_attr(trim(get_option(YAOLA_PRODUCT_VERSION))) == 'v5' ? 'checked' : '';?>>
            <label for = 'v5'><img src="<?php echo plugins_url('../static/v5-label.png', __FILE__); ?>" style="width: 300px;"></a></label> &nbsp;
            <input id = 'v6' type="radio" name="<?php echo YAOLA_PRODUCT_VERSION; ?>" value="v6" <?php echo esc_attr(trim(get_option(YAOLA_PRODUCT_VERSION))) == 'v6' ? 'checked' : '';?>>
            <label for = 'v6'><img src="<?php echo plugins_url('../static/v6-label.png', __FILE__); ?>" style="width: 300px;"></label>
            <p style="font-weight:600;">两个统计版本ID互不相同，如切换版本请按步骤修改</p>
            <h3>安装步骤：<span style="color: #999; font-size: 12px;">(如已有账号并创建应用请跳过直接查看第二步)</span></h3>
            <div class="<?php echo YAOLA_PRODUCT_VERSION; ?>_v5" style="<?php echo esc_attr(trim(get_option(YAOLA_PRODUCT_VERSION))) == 'v5' ? 'display:block;' : 'display:none;';?>">
                <h4>第一步：注册51LA账号</h4>
                <p>前往 <a href="https://web.51.la" target="_blank">51LA网站统计（v5）</a> 注册账号，创建您的网站应用，获取应用ID。</p>
                <h4>第二步：前往 <a href="https://web.51.la/user/site/index" target="_blank" >站点管理页</a> 复制站点ID</h4>
                <p>
                    <img src="<?php echo plugins_url('../static/v5-id.png', __FILE__); ?>" style="width: 300px;"></a>
                </p>
            </div>
            <div class="<?php echo YAOLA_PRODUCT_VERSION; ?>_v6" style="<?php echo esc_attr(trim(get_option(YAOLA_PRODUCT_VERSION))) == 'v6' ? 'display:block;' : 'display:none;';?>">
                <h4>第一步：注册51LA账号</h4>
                <p>前往 <a href="https://v6.51.la?cc=YWEGU5" target="_blank">51LA网站统计（v6）</a> 注册账号，创建您的网站应用，获取应用ID。</p>
                <h4>第二步：前往 <a href="https://v6.51.la/user/application" target="_blank" >站点管理页</a> 复制统计掩码ID</h4>
                <p>
                    <img src="<?php echo plugins_url('../static/v6-id.png', __FILE__); ?>" style="width: 350px;"></a>
                </p>
            </div>
            <h4>第三步：添加保存ID</h4>
            <table class="form-table">
                <p class="<?php echo YAOLA_PRODUCT_VERSION; ?>_v5"  style="<?php echo esc_attr(trim(get_option(YAOLA_PRODUCT_VERSION))) == 'v5' ? 'display:block;' : 'display:none;';?>">把复制到的应用 ID 粘贴到下方文本框并保存，提示安装成功后即可使用 51LA 网站统计，不填写不生效。</p>
                <p class="<?php echo YAOLA_PRODUCT_VERSION; ?>_v6"  style="<?php echo esc_attr(trim(get_option(YAOLA_PRODUCT_VERSION))) == 'v6' ? 'display:block;' : 'display:none;';?>">把复制到的掩码 ID 粘贴到下方文本框并保存，提示安装成功后即可使用 51LA 网站统计，不填写不生效。</p>
                <div class="<?php echo YAOLA_PRODUCT_VERSION; ?>_v5"  style="<?php echo esc_attr(trim(get_option(YAOLA_PRODUCT_VERSION))) == 'v5' ? 'display:block;' : 'display:none;';?>">
                    <input
                        style="width: 180px; border: 1px solid #ccc; text-align: left; padding: 10px;
                        margin: 10px 0; line-height: 1; height: 40px;"
                        name="<?php echo YAOLA_PRODUCT_ID; ?>"
                        id="<?php echo YAOLA_PRODUCT_ID; ?>"
                        placeholder="请填写您的应用ID"
                        value="<?php echo esc_attr(trim(get_option(YAOLA_PRODUCT_ID))); ?>"/>
                </div>
                <div class="<?php echo YAOLA_PRODUCT_VERSION; ?>_v6"  style="<?php echo esc_attr(trim(get_option(YAOLA_PRODUCT_VERSION))) == 'v6' ? 'display:block;' : 'display:none;';?>">
                    <input
                        style="width: 180px; border: 1px solid #ccc; text-align: left; padding: 10px;
                        margin: 10px 0; line-height: 1; height: 40px;"
                        name="<?php echo YAOLA_PRODUCT_ID; ?>"
                        id="<?php echo YAOLA_PRODUCT_ID; ?>"
                        placeholder="请填写您的掩码ID"
                        value="<?php echo esc_attr(trim(get_option(YAOLA_PRODUCT_ID))); ?>"/>
                </div>
                <div class="<?php echo YAOLA_PRODUCT_VERSION; ?>_v6" style="<?php echo esc_attr(trim(get_option(YAOLA_PRODUCT_VERSION))) == 'v6' ? 'display:block;' : 'display:none;';?>">
                    <h4>代码引入方式：</h4>
                    <input id = 'sync' type="radio" name="<?php echo YAOLA_PRODUCT_IMPORT_TYPE; ?>" value="sync" <?php echo esc_attr(trim(get_option(YAOLA_PRODUCT_IMPORT_TYPE))) == 'sync' ? 'checked' : '';?>>
                    <label for = 'sync'>同步引入</label> &nbsp;
                    <input id = 'async' type="radio" name="<?php echo YAOLA_PRODUCT_IMPORT_TYPE; ?>" value="async" <?php echo esc_attr(trim(get_option(YAOLA_PRODUCT_IMPORT_TYPE))) == 'async' ? 'checked' : '';?>>
                    <label for = 'async'>异步引入</label>
                </div>
                <br />
            </table>
        </div>
        <script>
            jQuery('input[type=radio][name=<?php echo YAOLA_PRODUCT_VERSION; ?>]').change(function () {
                var myvalue = jQuery(this).val();
                if (myvalue == 'v5') {
                    jQuery('.<?php echo YAOLA_PRODUCT_VERSION; ?>_v6').hide();
                    jQuery('.<?php echo YAOLA_PRODUCT_VERSION; ?>_' + myvalue).show();
                }
                if (myvalue == 'v6') {
                    jQuery('.<?php echo YAOLA_PRODUCT_VERSION; ?>_v5').hide();
                    jQuery('.<?php echo YAOLA_PRODUCT_VERSION; ?>_' + myvalue).show();
                }
            });
        </script>
        <style>
            a.info-button {
                margin: 5px 20px 5px 0;
                cursor: pointer;
                color: #fff;
                background-color: #1690ff;
                border-color: #1690ff;
                display: inline-block;
                font-weight: 400;
                line-height: 1.2;
                text-align: center;
                text-decoration: none;
                vertical-align: middle;
                -webkit-user-select: none;
                -moz-user-select: none;
                user-select: none;
                padding: 8px 15px;
                font-size: 14px;
                border-radius: .25rem;
            }

            p.submit {
                display: inline-block;
                margin-top: -10px;
            }
        </style>
        <?php submit_button(); ?>
    </form>
    <img src="//ia.51.la/go1?id=21261191&pvFlag=1" style="border:none;height:1px;width:1px;" />
</div>
