# MeEdu 服务化架构

## 初衷

MVC 是 PHP 开发当中流行了数十年的设计模式。但是，现如今，随着业务的复杂度的提高，传统的 MVC 架构已经无法有效的满足在保证代码清晰的同时，能够很好的
兼顾业务。基于此，延伸出了许多代码层面的架构和设计。比如说：引入 Service 的概念，将传统的 Model 与业务逻辑分开。这种代码层面的架构在许多的公司项目
中都有见到，但是随着业务复杂度的提高和需求的持续迭代，我们会发现，Service 层的代码越来越臃肿，变得难以维护！所以，聪明的 PHPer 开始尽可能的抽离Service
，划分好每个 Service 的职责范围。但是系统毕竟是由团队合作开发的，其中参与的每一个人都无法达到高度的思想统一！所以，一个项目维护时间长久之后，随着团队
人员的变动，后来者看到代码，脑子中只有一个词：“重构”！。
MeEdu 在设计之初，代码层面的架构其实也脱离不了 MVC 的范畴，你可以处处看到它的影子。作者在持续维护 MeEdu 的过程中，随着技术提升和视野的转变，对于系统
有了更深入的了解，于是决定对 MeEdu 进行一次变化较为彻底的重新架构设计：服务化设计！引入该设计的目的是使 MeEdu 的代码耦合度更低，更易于维护，单元测试
覆盖率更高！

## 目标

+ 代码耦合度更低
+ 业务职责划分更为彻底
+ 微服务架构设计，服务替换无感知
+ 达到更高的单元测试覆盖率
+ 让支持 MeEdu 的小伙伴花费最少的时间参与 MeEdu 的开发

## 服务列表

| 服务 | 说明 |
| --- | --- |
| `Base` | 系统底层服务，主要有：缓存，配置服务等 |
| `Member` | 会员服务，负责 MeEdu 系统的会员注册/登录/找回密码/会员等级等 |
| `Course` | 课程服务，主要提供课程/视频在线观看 |
| `Order` | 订单服务，主要提供课程/视频/会员的在线购买服务 |
| `Other` | 其它服务，主要是系统的一些小功能，包括像：上传，短信发送等 |

## 规则

+ 除了 `BaseSerice` 可以被其它服务任意调用之外，其余的服务之间**禁止**互相调用。
+ 单个服务内的 `Service` 可以互相调用。
+ 所有的服务都必须通过注入的方式使用。
+ 所有服务的返回值都必须为基础数据类型，如：数组，布尔值等。禁止返回诸如 Model对象，Collection对象等。
+ 应用其它层可以任意的调用各种服务。
+ 全局只可以使用 `Auth::id()` 和 `Auth::check()` 方法，禁止使用 `Auth::user()` 来获取当前登录用户，因为这个方法返回的是 `Model` 对象。

## 规则解释

+ 问：为什么禁止使用 `Auth::user()` 方法？

答：因为 `Auth::user()` 返回的是 `UserModel` 对象，该对象可以直接操作数据库！这是不允许的，所以的操作数据库行为都必须写在相应的 `Service` 里面。

+ 问：为什么服务方法必须返回基础数据类型？

答：微服务设计不仅仅要考虑到Laravel或者PHP开发的应用，也有可能还有其它的语言！因此，为了服务的通用性，服务方法必须返回基础数据类型。

