
## 微服务的代码架构-V2

V2 的架构相较于之前的架构方案更加突出：

+ less framework
+ quick replace

#### less framework

更加的强调与框架无关。也就是将与框架相关的东西做到最小单元控制，理想状态下就是与框架强关联的代码全部在
可控范围内。为什么要强调 `less framework` ? 我们要知道的是作为运营方如果在正向发展的情况下，业务的
规模增长是越来越快的，但是 `laravel` 框架本身的局限导致并发能力上不去，虽然在早期通过堆积服务器做负载
均衡能够支撑一定规模的用户量，但是更大的话就够呛了。但是因为业务代码都写在了这里，如果突然切换的话很明显
不是很现实，所以，在代码架构的开始，我们就要做到 `less framework` 这样的话我们切换性能更高的框架(比如
swoole)的话就更加平滑。

#### quick replace

服务做到 `less framework` 的情况下，要做到 `quick replace` 的话也就不难了。还是老问题，负载的增加
肯定选择性能更好的方案才是最为明智的，但是业务的迁移并不是一次完成而是一个逐步按照缓重轻急缓慢的过程。因此
做到 `quick replace` 才能更好的应对未来的流量增长。`quick replace` 更加强调 `less language` 。也
就是与开发语言关联度更低，它强调的是多个开发语言之间可以无缝的切换服务而不会产生影响。在这样的前提下，因
负载而切换部分业务也就变得极为容易。
