<div align="center">
  <img src="src/assets/logo-cover.png" width=256></img>
  <p><strong>Общайтесь со ВСЕМИ искусственными ботами одновременно, открывайте для себя лучшие</strong></p>

[Deutsch](README_DE-DE.md) | [English](README.md) | [Español](README_ES-ES.md) | [Français](README_FR-FR.md) | [Italian](README_IT-IT.md) | [日本語](README_JA-JP.md) | [한국어](README_KO-KR.md) | Русский | [Tiếng Việt](README_VI-VN.md) | [简体中文](README_ZH-CN.md)

</div>

## Скриншоты

![Скриншот](screenshots/screenshot-1.png?raw=true)

## Возможности

ИИ-боты, основанные на больших языковых моделях (LLM) потрясающи. Однако их поведение может быть случайным, и разные боты преуспевают в выполнении разных задач. Если вы хотите получить наилучшие впечатления, не пробуйте их по одному. ChatALL (китайское название: 齐叨) может отправлять запросы нескольким ботам с искусственным интеллектом одновременно, помогая вам находить наилучшие результаты. Все, что вам нужно сделать, это [загрузить, установить](https://github.com/sunner/ChatALL/releases) и спросить.

### Это вы?

Типичными пользователями ChatALL являются:

- 🤠**Гуру LLM**, которые хотят найти лучшие ответы или творения от LLM.
- 🤓**Исследователи LLM**, которые хотят интуитивно сравнить сильные и слабые стороны различных LLM в разных областях.
- 😎**Разработчики приложений LLM**, которые хотят быстро отлаживать запросы и находить наиболее эффективные базовые модели.

### Поддерживаемые боты

| ИИ-боты                                                                        | Доступ к интернету | API         | Подпись                                           |
| ------------------------------------------------------------------------------ | ------------------ | ----------- | ------------------------------------------------- |
| [ChatGPT](https://chat.openai.com)                                             | Да                 | Да          | Просмотр веб-страниц, включая службу Azure OpenAI |
| [Bing Chat](https://www.bing.com/new)                                          | Да                 | Нет API     |                                                   |
| [Baidu ERNIE](https://yiyan.baidu.com/)                                        | Нет                | Да          |                                                   |
| [Bard](https://bard.google.com/)                                               | Да                 | Скоро будет |                                                   |
| [Poe](https://poe.com/)                                                        | Да                 | Скоро будет |                                                   |
| [MOSS](https://moss.fastnlp.top/)                                              | Да                 | Нет API     |                                                   |
| [Tongyi Qianwen](http://tongyi.aliyun.com/)                                    | Да                 | Скоро будет |                                                   |
| [Dedao Learning Assistant](https://ai.dedao.cn/)                               | Скоро будет        | Нет API     |                                                   |
| [iFLYTEK SPARK](http://xinghuo.xfyun.cn/)                                      | Да                 | Скоро будет |                                                   |
| [Alpaca](https://crfm.stanford.edu/2023/03/13/alpaca.html)                     | Да                 | Нет API     | Вход в ученую запись не требуется                 |
| [Vicuna 7B, 13B & 33B](https://lmsys.org/blog/2023-03-30-vicuna/)              | Да                 | Нет API     | Вход в ученую запись не требуется                 |
| [ChatGLM2 6B & 130B](https://chatglm.cn/)                                      | Да                 | Нет API     | Вход в ученую запись не требуется                 |
| [Claude 2 & Instant](https://www.anthropic.com/index/claude-2)                 | Да                 | Нет API     |                                                   |
| [Gradio](https://gradio.app/)                                                  | Да                 | Нет API     | For Hugging Face space/self-deployed models       |
| [HuggingChat](https://huggingface.co/chat/)                                    | Да                 | Нет API     |                                                   |
| [SkyWork](https://neice.tiangong.cn/)                                          | Да                 | Скоро будет |                                                   |
| [You](https://you.com/)                                                        | Да                 | Нет API     |                                                   |
| [Pi](https://pi.ai)                                                            | Да                 | Нет API     |                                                   |
| [360 AI Brain](https://ai.360.cn/)                                             | Да                 | Нет API     |                                                   |
| [YouChat](https://you.com/)                                                    | Да                 | Нет API     |                                                   |
| [Open Assistant](https://open-assistant.io/)                                   | Да                 | Нет API     |                                                   |
| [Character.AI](https://character.ai/)                                          | Да                 | Нет API     |                                                   |
| [Llama 2 7B, 13B & 70B](https://ai.meta.com/llama/)                            | Да                 | Нет API     |                                                   |
| [Code Llama](https://ai.meta.com/blog/code-llama-large-language-model-coding/) | Да                 | Нет API     |                                                   |
| [WizardLM 13B & 70B](https://github.com/nlpxucan/WizardLM)                     | Да                 | Нет API     |                                                   |
| [Falcon 180B](https://tiiuae-falcon-180b-demo.hf.space/)                       | Да                 | Нет API     |                                                   |

Скоро будет еще больше. Проголосуйте за своих любимых ботов в [этих issues](https://github.com/sunner/ChatALL/labels/more%20LLMs).

### Другие функции

- Режим быстрого запроса: отправьте следующее приглашение, не дожидаясь завершения предыдущего запроса
- Сохраняйте историю чата локально, защищайте вашу частную жизнь
- Выделите понравившийся вам ответ, удалите плохой
- Включать / отключать любых ботов в любое время
- Переключение между просмотром в одну, две или три колонки
- Автоматическое обновление до последней версии
- Темный режим (автор @tanchekwei)
- Короткие клавиши. Нажмите "Ctrl + /", чтобы узнать их все (автор @tanchekwei)
- Несколько чатов (автор: @tanchekwei)
- Настройка прокси-сервера (предоставлено @msaong)
- Управление запросами (автор @tanchekwei)
- Поддерживает несколько языков (Китайский, Английский, Немецкий, Французкий, Русский, Вьетнамский, Корейский, Японский, Испанский, Итальянский).
- Поддерживает Windows, macOS и Linux

Планируемые функции:

Вы можете внести свой вклад в эти функции.

- [ ] Развертывание фронт-энда на GitHub Pages

## Условия

ChatALL - это клиент, а не прокси. Следовательно, вы должны:

1. Иметь рабочие учетные записи и/или токены API для ботов.
2. Обеспечьте надежное сетевое подключение к ботам.
3. Если вы используете VPN, он должен быть настроен как системный/глобальный прокси.

## Скачать / установить

Скачать с https://github.com/sunner/ChatALL/releases

### В Windows

Просто скачайте \*-win.exe сохраните файл и приступайте к настройке.

### На macOS

Для Apple Silicon Mac (процессор M1, M2) загрузите файл \*-mac-arm64.dmg.

Для других компьютеров Mac загрузите файл \*-mac-x64.dmg.

Если вы используете [Homebrew](https://brew.sh/), вы также можете установить его с помощью:

```bash
brew install --cask chatall
```

### On Linux

Скачайте файл .AppImage, сделайте его исполняемым и наслаждайтесь процессом запуска по щелчку мыши.

## Решение проблем

Если вы столкнетесь с какими-либо проблемами при использовании ChatALL, вы можете попробовать следующие методы их устранения:

1. **Обновить** - нажмите `Ctrl + R` или `Cmd + R`.
2. **Перезапустить** - выйдите из ChatALL и запустите его снова.
3. **Повторный вход в систему** - нажмите кнопку настройки в правом верхнем углу, затем перейдите по соответствующей ссылке входа/выхода из системы, чтобы повторно войти на вебсайт.
4. **Создайте новый чат** - нажмите кнопку "Создать чат" и отправьте запрос еще раз.

Если ни один из вышеперечисленных методов не работает, вы можете попробовать **сбросить настройки ChatALL**. Обратите внимание, что при этом будут удалены все ваши настройки и история сообщений.

Вы можете сбросить настройки ChatALL, удалив следующие каталоги:

- Windows: `C:\Users\<user>\AppData\Roaming\chatall\`
- Linux: `/home/<user>/.config/chatall/`
- macOS: `/Users/<user>/Library/Application Support/chatall/`

Если проблема не устранена, пожалуйста, [отправьте issue](https://github.com/sunner/ChatALL/issues).

## Для разработчиков

### Сделать бота

[Этот гайд](https://github.com/sunner/ChatALL/wiki/%E5%A6%82%E4%BD%95%E6%B7%BB%E5%8A%A0%E4%B8%80%E4%B8%AA%E6%96%B0%E7%9A%84-AI-%E5%AF%B9%E8%AF%9D%E6%9C%BA%E5%99%A8%E4%BA%BA) может помочь вам.

### Запуск

```bash
npm install
npm run electron:serve
```

### Сборка

Сборка для вашей текущей платформы:

```bash
npm run electron:build
```

Сборка для всех платформ:

```bash
npm run electron:build -- -wml --x64 --arm64
```

## Благодарность

### Участники

<a href="https://github.com/sunner/ChatALL/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=sunner/ChatALL" />
</a>

### Другие

- GPT-4 внес большой вклад в разработку кода
- ChatGPT, Bing Chat и Google предоставляют множество решений (ранжированных по порядку)
- Вдохновленно с помощью [ChatHub](https://github.com/chathub-dev/chathub). Респект!

## Поддержать

Если вам нравится этот проект, пожалуйста, рассмотрите:

[![ko-fi](https://ko-fi.com/img/githubbutton_sm.svg)](https://ko-fi.com/F1F8KZJGJ)
