<div align="center">
  <img src="src/assets/logo-cover.png" width=256></img>
  <p><strong>Chatta contemporaneamente con TUTTI gli IA Bots, scopri il migliore</strong></p>

[Deutsch](README_DE-DE.md) | [English](README.md) | [Español](README_ES-ES.md) | [Français](README_FR-FR.md) | Italian | [日本語](README_JA-JP.md) | [한국어](README_KO-KR.md) | [Русский](README_RU-RU.md) | [Tiếng Việt](README_VI-VN.md) | [简体中文](README_ZH-CN.md)

</div>

## Screenshots

![Screenshot](screenshots/screenshot-1.png?raw=true)

## Caratteristiche

I Bot IA basati su Large Language Models (LLMs) sono sorprendenti. Tuttavia, il loro comportamento può essere casuale e diversi bot eccellono in diverse attività. Se desideri la migliore esperienza, non provarli uno per uno. ChatALL (nome cinese: 齐叨) può inviare prompt a diversi IA Bot contemporaneamente, aiutandoti a scoprire i migliori risultati. Tutto ciò che devi fare è [scaricare, installare](https://github.com/sunner/ChatALL/releases) e chiedere .

### Sei uno di questi?

Gli utenti tipici di ChatALL sono:

- 🤠**Guru dei LLM**, che vogliono trovare le migliori risposte o creazioni dai LLM.
- 🤓**Ricercatori dei LLM**, che vogliono confrontare intuitivamente i punti di forza e di debolezza di vari LLM in diversi campi.
- 😎**Sviluppatori di applicazioni dei LLM**, che vogliono debuggare rapidamente i prompt e trovare i modelli di base più performanti.

### Bot supportati

| IA Bots                                                      | Web Access    | API           | Notes                                        |
| ------------------------------------------------------------ | ------------- | ------------- | -------------------------------------------- |
| [ChatGPT](https://chat.openai.com)                           | Sì            | Sì            | Navigazione Web,include servizi Azure-OpenAI |
| [Bing Chat](https://www.bing.com/new)                        | Sì            | No API        | Nessun accesso richiesto                     |
| [Baidu ERNIE](https://yiyan.baidu.com/)                      | No            | Si            |                                              |
| [Bard](https://bard.google.com/)                             | Sì            | Prossimamente |                                              |
| [Poe](https://poe.com/)                                      | Sì            | Prossimamente |                                              |
| [MOSS](https://moss.fastnlp.top/)                            | Sì            | No API        |                                              |
| [Tongyi Qianwen](http://tongyi.aliyun.com/)                  | Sì            | Prossimamente |                                              |
| [Dedao Learning Assistant](https://ai.dedao.cn/)             | Prossimamente | No API        |                                              |
| [iFLYTEK SPARK](http://xinghuo.xfyun.cn/)                    | Sì            | Prossimamente |                                              |
| [Alpaca](https://crfm.stanford.edu/2023/03/13/alpaca.html)   | Sì            | No API        | Nessun accesso richiesto                     |
| [Vicuna](https://lmsys.org/blog/2023-03-30-vicuna/)          | Sì            | No API        | Nessun accesso richiesto                     |
| [ChatGLM](https://chatglm.cn/blog)                           | Sì            | No API        | Nessun accesso richiesto                     |
| [Claude](https://www.anthropic.com/index/introducing-claude) | Sì            | No API        | Nessun accesso richiesto                     |
| [Gradio](https://gradio.app/)                                | Sì            | No API        | Per modelli Hugging Face/spazio auto-deploy  |
| [HuggingChat](https://huggingface.co/chat/)                  | Sì            | No API        |                                              |
| [SkyWork](https://neice.tiangong.cn/)                        | Sì            | Prossimamente |                                              |
| [You](https://you.com/)                                      | Sì            | No API        |                                              |
| [Pi](https://pi.ai)                                          | Sì            | No API        |                                              |

Altri sono in arrivo. Vota i tuoi bot preferiti in [questi problemi](https://github.com/sunner/ChatALL/labels/more%20LLMs).

### Altre funzionalità

- Modalità prompt rapido: invia il prompt successivo senza attendere il completamento della richiesta precedente.
- Salva la cronologia delle chat localmente, proteggendo la tua privacy.
- Evidenzia la risposta che ti piace, elimina quelle indesiderate.
- Abilita/disabilita i bot in qualsiasi momento.
- Passa tra la vista a una, due o tre colonne.
- Aggiornamento automatico all'ultima versione.
- Modalità scura (contribuita da @tanchekwei).
- Scorciatoie da tastiera. Premi `Ctrl + /` per conoscerle tutte (contribuite da @tanchekwei).
- Chat multiple (contribuite da @tanchekwei).
- Supporto per l'impostazione del proxy (contribuito da @msaong).
- Supporto per diverse lingue (cinese, inglese, tedesco, francese, russo, vietnamita, coreano, giapponese, spagnolo, italiano).
- Supporto per Windows, macOS e Linux.

Funzionalità pianificate:

Siete benvenuti a contribuire a queste funzionalità.

- [ ] Deploy del front-end su Pagine GitHub

## Prerequisiti

ChatALL è un client, non un proxy. Pertanto, devi:

markdown

<div align="center">
  <img src="src/assets/logo-cover.png" width=256></img>
  <p><strong>Chatta contemporaneamente con TUTTI gli AI Bots, scopri il migliore</strong></p>

[Deutsch](README_DE-DE.md) | Italiano | [Español](README_ES-ES.md) | [Français](README_FR-FR.md) | [日本語](README_JA-JP.md) | [한국어](README_KO-KR.md) | [Tiếng Việt](README_VI-VN.md) | [简体中文](README_ZH-CN.md)

</div>

## Screenshots

![Screenshot](screenshots/screenshot-1.png?raw=true)

## Caratteristiche

I Bot AI basati su Large Language Models (LLMs) sono sorprendenti. Tuttavia, il loro comportamento può essere casuale e diversi bot eccellono in diverse attività. Se desideri la migliore esperienza, non provarli uno per uno. ChatALL (nome cinese: 齐叨) può inviare prompt a diversi AI bot contemporaneamente, aiutandoti a scoprire i migliori risultati. Tutto ciò che devi fare è [scaricare, installare](https://github.com/sunner/ChatALL/releases) e chiedere.

### Sei uno di questi?

Gli utenti tipici di ChatALL sono:

- 🤠**Guru dei LLM**, che vogliono trovare le migliori risposte o creazioni dai LLM.
- 🤓**Ricercatori dei LLM**, che vogliono confrontare intuitivamente i punti di forza e di debolezza di vari LLM in diversi campi.
- 😎**Sviluppatori di applicazioni dei LLM**, che vogliono debuggare rapidamente i prompt e trovare i modelli di base più performanti.

### Bot supportati

| AI Bots                                                      | Accesso Web   | API           | Note                                          |
| ------------------------------------------------------------ | ------------- | ------------- | --------------------------------------------- |
| [ChatGPT](https://chat.openai.com)                           | Sì            | Sì            | Navigazione Web, include Azure OpenAI service |
| [Bing Chat](https://www.bing.com/new)                        | Sì            | No API        | Nessun accesso richiesto                      |
| [Baidu ERNIE](https://yiyan.baidu.com/)                      | No            | Sì            |                                               |
| [Bard](https://bard.google.com/)                             | Sì            | Prossimamente |                                               |
| [Poe](https://poe.com/)                                      | Sì            | Prossimamente |                                               |
| [MOSS](https://moss.fastnlp.top/)                            | Sì            | No API        |                                               |
| [Tongyi Qianwen](http://tongyi.aliyun.com/)                  | Sì            | Prossimamente |                                               |
| [Dedao Learning Assistant](https://ai.dedao.cn/)             | Prossimamente | No API        |                                               |
| [iFLYTEK SPARK](http://xinghuo.xfyun.cn/)                    | Sì            | Prossimamente |                                               |
| [Alpaca](https://crfm.stanford.edu/2023/03/13/alpaca.html)   | Sì            | No API        | Nessun accesso richiesto                      |
| [Vicuna](https://lmsys.org/blog/2023-03-30-vicuna/)          | Sì            | No API        | Nessun accesso richiesto                      |
| [ChatGLM](https://chatglm.cn/blog)                           | Sì            | No API        | Nessun accesso richiesto                      |
| [Claude](https://www.anthropic.com/index/introducing-claude) | Sì            | No API        | Nessun accesso richiesto                      |
| [Gradio](https://gradio.app/)                                | Sì            | No API        | Per modelli Hugging Face/spazio auto-deploy   |
| [HuggingChat](https://huggingface.co/chat/)                  | Sì            | No API        |                                               |
| [SkyWork](https://neice.tiangong.cn/)                        | Sì            | Prossimamente |                                               |
| [You](https://you.com/)                                      | Sì            | No API        |                                               |
| [Pi](https://pi.ai)                                          | Sì            | No API        |                                               |

Altri sono in arrivo. Vota i tuoi bot preferiti in [questi problemi](https://github.com/sunner/ChatALL/labels/more%20LLMs).

### Altre funzionalità

- Modalità prompt rapido: invia il prompt successivo senza attendere il completamento della richiesta precedente.
- Salva la cronologia delle chat localmente, proteggendo la tua privacy.
- Evidenzia la risposta che ti piace, elimina quelle indesiderate.
- Abilita/disabilita i bot in qualsiasi momento.
- Passa tra la vista a una, due o tre colonne.
- Aggiornamento automatico all'ultima versione.
- Modalità scura (contribuita da @tanchekwei).
- Scorciatoie da tastiera. Premi `Ctrl + /` per conoscerle tutte (contribuite da @tanchekwei).
- Chat multiple (contribuite da @tanchekwei).
- Supporto per l'impostazione del proxy (contribuito da @msaong).
- Supporto per diverse lingue (cinese, inglese, tedesco, francese, russo, vietnamita, coreano, giapponese, spagnolo, italiano).
- Supporto per Windows, macOS e Linux.

Funzionalità pianificate:

Siete benvenuti a contribuire a queste funzionalità.

- [ ] Deploy del front-end su GitHub Pages

## Prerequisiti

ChatALL è un client, non un proxy. Pertanto, devi:

1. Avere account funzionanti e/o token API per i bot.
2. Avere connessioni di rete affidabili ai bot.
3. Se stai usando una VPN, devi impostarla come proxy di sistema/globale.

## Download / Installazione

Scarica da https://github.com/sunner/ChatALL/releases

### Su Windows

Basta scaricare il file \*-win.exe e procedere con l'installazione.

### Su macOS

Per Mac con processori Apple Silicon (M1, M2), scarica il file \*-mac-arm64.dmg.

Per gli altri Mac, scarica il file \*-mac-x64.dmg.

Se stai usando [Homebrew](https://brew.sh/), puoi installarlo anche con:

```bash
brew install --cask chatall
```

### Su Linux

Scarica il file .AppImage, rendilo eseguibile e goditi l'esperienza del clic.

## Risoluzione dei problemi

If you encounter any problems while using ChatALL, you can try the following methods to resolve them:

1. **Ricarica** - premi `Ctrl + R` o `Cmd + R`.
2. **Riavvia** - esci da ChatALL e avvialo nuovamente.
3. **Rilogin** - clicca sul pulsante delle impostazioni nell'angolo in alto a destra, quindi clicca sul link di accesso/uscita corrispondente nella finestra popup per accedere nuovamente al sito web.
4. **Cancella tutti i messaggi** - clicca sul pulsante della scopa nell'angolo in alto a destra.

Se nessuno dei metodi sopra elencati funziona, puoi provare a **reimpostare ChatALL**. Nota che ciò cancellerà tutte le tue impostazioni e la cronologia dei messaggi.

Puoi reimpostare ChatALL eliminando le seguenti directory:

- Windows: `C:\Users\<user>\AppData\Roaming\chatall\`
- Linux: `/home/<user>/.config/chatall/`
- macOS: `/Users/<user>/Library/Application Support/chatall/`

Se il problema persiste, per favore [segnala il problema](https://github.com/sunner/ChatALL/issues).

## Per gli sviluppatori

### Contribuisci con un Bot

[Guida](https://github.com/sunner/ChatALL/wiki/%E5%A6%82%E4%BD%95%E6%B7%BB%E5%8A%A0%E4%B8%80%E4%B8%AA%E6%96%B0%E7%9A%84-AI-%E5%AF%B9%E8%AF%9D%E6%9C%BA%E5%99%A8%E4%BA%BA) potrebbe esserti utile.

### Esegui

```bash
npm install
npm run electron:serve
```

### Compila

Compila per la tua piattaforma corrente:

```bash
npm run electron:build
```

Compila per tutte le piattaforme:

```bash
npm run electron:build -- -wml --x64 --arm64
```

## Crediti

### Collaboratori

<a href="https://github.com/sunner/ChatALL/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=sunner/ChatALL" />
</a>

### Altri

- GPT-4 ha contribuito gran parte del codice.
- ChatGPT, Bing Chat e Google hanno fornito molte soluzioni (elencati in ordine).
- Progetto ispirato da [ChatHub](https://github.com/chathub-dev/chathub). Rispetto!

## Sponsor

Se ti piace questo progetto, per favore considera:

[![ko-fi](https://ko-fi.com/img/githubbutton_sm.svg)](https://ko-fi.com/F1F8KZJGJ)
