var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
define("h", ["require", "exports", "./vnode", "./is"], function (require, exports, vnode_1, is) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.h = void 0;
    is = __importStar(is);
    function addNS(data, children, sel) {
        data.ns = "http://www.w3.org/2000/svg";
        if (sel !== "foreignObject" && children !== undefined) {
            for (var i = 0; i < children.length; ++i) {
                var childData = children[i].data;
                if (childData !== undefined) {
                    addNS(childData, children[i].children, children[i].sel);
                }
            }
        }
    }
    function h(sel, b, c) {
        var data = {};
        var children;
        var text;
        var i;
        if (c !== undefined) {
            if (b !== null) {
                data = b;
            }
            if (is.array(c)) {
                children = c;
            }
            else if (is.primitive(c)) {
                text = c.toString();
            }
            else if (c && c.sel) {
                children = [c];
            }
        }
        else if (b !== undefined && b !== null) {
            if (is.array(b)) {
                children = b;
            }
            else if (is.primitive(b)) {
                text = b.toString();
            }
            else if (b && b.sel) {
                children = [b];
            }
            else {
                data = b;
            }
        }
        if (children !== undefined) {
            for (i = 0; i < children.length; ++i) {
                if (is.primitive(children[i]))
                    children[i] = (0, vnode_1.vnode)(undefined, undefined, undefined, children[i], undefined);
            }
        }
        if (sel[0] === "s" &&
            sel[1] === "v" &&
            sel[2] === "g" &&
            (sel.length === 3 || sel[3] === "." || sel[3] === "#")) {
            addNS(data, children, sel);
        }
        return (0, vnode_1.vnode)(sel, data, children, text, undefined);
    }
    exports.h = h;
});
define("hooks", ["require", "exports"], function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
});
define("htmldomapi", ["require", "exports"], function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.htmlDomApi = void 0;
    function createElement(tagName, options) {
        return document.createElement(tagName, options);
    }
    function createElementNS(namespaceURI, qualifiedName, options) {
        return document.createElementNS(namespaceURI, qualifiedName, options);
    }
    function createTextNode(text) {
        return document.createTextNode(text);
    }
    function createComment(text) {
        return document.createComment(text);
    }
    function insertBefore(parentNode, newNode, referenceNode) {
        parentNode.insertBefore(newNode, referenceNode);
    }
    function removeChild(node, child) {
        node.removeChild(child);
    }
    function appendChild(node, child) {
        node.appendChild(child);
    }
    function parentNode(node) {
        return node.parentNode;
    }
    function nextSibling(node) {
        return node.nextSibling;
    }
    function tagName(elm) {
        return elm.tagName;
    }
    function setTextContent(node, text) {
        node.textContent = text;
    }
    function getTextContent(node) {
        return node.textContent;
    }
    function isElement(node) {
        return node.nodeType === 1;
    }
    function isText(node) {
        return node.nodeType === 3;
    }
    function isComment(node) {
        return node.nodeType === 8;
    }
    exports.htmlDomApi = {
        createElement: createElement,
        createElementNS: createElementNS,
        createTextNode: createTextNode,
        createComment: createComment,
        insertBefore: insertBefore,
        removeChild: removeChild,
        appendChild: appendChild,
        parentNode: parentNode,
        nextSibling: nextSibling,
        tagName: tagName,
        setTextContent: setTextContent,
        getTextContent: getTextContent,
        isElement: isElement,
        isText: isText,
        isComment: isComment,
    };
});
define("init", ["require", "exports", "./vnode", "./is", "./htmldomapi"], function (require, exports, vnode_2, is, htmldomapi_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.init = void 0;
    is = __importStar(is);
    function isUndef(s) {
        return s === undefined;
    }
    function isDef(s) {
        return s !== undefined;
    }
    var emptyNode = (0, vnode_2.vnode)("", {}, [], undefined, undefined);
    function sameVnode(vnode1, vnode2) {
        var _a, _b;
        var isSameKey = vnode1.key === vnode2.key;
        var isSameIs = ((_a = vnode1.data) === null || _a === void 0 ? void 0 : _a.is) === ((_b = vnode2.data) === null || _b === void 0 ? void 0 : _b.is);
        var isSameSel = vnode1.sel === vnode2.sel;
        return isSameSel && isSameKey && isSameIs;
    }
    function isVnode(vnode) {
        return vnode.sel !== undefined;
    }
    function createKeyToOldIdx(children, beginIdx, endIdx) {
        var _a;
        var map = {};
        for (var i = beginIdx; i <= endIdx; ++i) {
            var key = (_a = children[i]) === null || _a === void 0 ? void 0 : _a.key;
            if (key !== undefined) {
                map[key] = i;
            }
        }
        return map;
    }
    var hooks = [
        "create",
        "update",
        "remove",
        "destroy",
        "pre",
        "post",
    ];
    function init(modules, domApi) {
        var cbs = {
            create: [],
            update: [],
            remove: [],
            destroy: [],
            pre: [],
            post: [],
        };
        var api = domApi !== undefined ? domApi : htmldomapi_1.htmlDomApi;
        for (var _i = 0, hooks_1 = hooks; _i < hooks_1.length; _i++) {
            var hook = hooks_1[_i];
            for (var _f = 0, modules_1 = modules; _f < modules_1.length; _f++) {
                var module_1 = modules_1[_f];
                var currentHook = module_1[hook];
                if (currentHook !== undefined) {
                    cbs[hook].push(currentHook);
                }
            }
        }
        function emptyNodeAt(elm) {
            var id = elm.id ? "#" + elm.id : "";
            var classes = elm.getAttribute("class");
            var c = classes ? "." + classes.split(" ").join(".") : "";
            return (0, vnode_2.vnode)(api.tagName(elm).toLowerCase() + id + c, {}, [], undefined, elm);
        }
        function createRmCb(childElm, listeners) {
            return function rmCb() {
                if (--listeners === 0) {
                    var parent_1 = api.parentNode(childElm);
                    api.removeChild(parent_1, childElm);
                }
            };
        }
        function createElm(vnode, insertedVnodeQueue) {
            var _a, _b;
            var i;
            var data = vnode.data;
            if (data !== undefined) {
                var init_1 = (_a = data.hook) === null || _a === void 0 ? void 0 : _a.init;
                if (isDef(init_1)) {
                    init_1(vnode);
                    data = vnode.data;
                }
            }
            var children = vnode.children;
            var sel = vnode.sel;
            if (sel === "!") {
                if (isUndef(vnode.text)) {
                    vnode.text = "";
                }
                vnode.elm = api.createComment(vnode.text);
            }
            else if (sel !== undefined) {
                var hashIdx = sel.indexOf("#");
                var dotIdx = sel.indexOf(".", hashIdx);
                var hash = hashIdx > 0 ? hashIdx : sel.length;
                var dot = dotIdx > 0 ? dotIdx : sel.length;
                var tag = hashIdx !== -1 || dotIdx !== -1
                    ? sel.slice(0, Math.min(hash, dot))
                    : sel;
                var elm = (vnode.elm =
                    isDef(data) && isDef((i = data.ns))
                        ? api.createElementNS(i, tag, data)
                        : api.createElement(tag, data));
                if (hash < dot)
                    elm.setAttribute("id", sel.slice(hash + 1, dot));
                if (dotIdx > 0)
                    elm.setAttribute("class", sel.slice(dot + 1).replace(/\./g, " "));
                for (i = 0; i < cbs.create.length; ++i)
                    cbs.create[i](emptyNode, vnode);
                if (is.array(children)) {
                    for (i = 0; i < children.length; ++i) {
                        var ch = children[i];
                        if (ch != null) {
                            api.appendChild(elm, createElm(ch, insertedVnodeQueue));
                        }
                    }
                }
                else if (is.primitive(vnode.text)) {
                    api.appendChild(elm, api.createTextNode(vnode.text));
                }
                var hook = vnode.data.hook;
                if (isDef(hook)) {
                    (_b = hook.create) === null || _b === void 0 ? void 0 : _b.call(hook, emptyNode, vnode);
                    if (hook.insert) {
                        insertedVnodeQueue.push(vnode);
                    }
                }
            }
            else {
                vnode.elm = api.createTextNode(vnode.text);
            }
            return vnode.elm;
        }
        function addVnodes(parentElm, before, vnodes, startIdx, endIdx, insertedVnodeQueue) {
            for (; startIdx <= endIdx; ++startIdx) {
                var ch = vnodes[startIdx];
                if (ch != null) {
                    api.insertBefore(parentElm, createElm(ch, insertedVnodeQueue), before);
                }
            }
        }
        function invokeDestroyHook(vnode) {
            var _a, _b;
            var data = vnode.data;
            if (data !== undefined) {
                (_b = (_a = data === null || data === void 0 ? void 0 : data.hook) === null || _a === void 0 ? void 0 : _a.destroy) === null || _b === void 0 ? void 0 : _b.call(_a, vnode);
                for (var i = 0; i < cbs.destroy.length; ++i)
                    cbs.destroy[i](vnode);
                if (vnode.children !== undefined) {
                    for (var j = 0; j < vnode.children.length; ++j) {
                        var child = vnode.children[j];
                        if (child != null && typeof child !== "string") {
                            invokeDestroyHook(child);
                        }
                    }
                }
            }
        }
        function removeVnodes(parentElm, vnodes, startIdx, endIdx) {
            var _a, _b;
            for (; startIdx <= endIdx; ++startIdx) {
                var listeners = void 0;
                var rm = void 0;
                var ch = vnodes[startIdx];
                if (ch != null) {
                    if (isDef(ch.sel)) {
                        invokeDestroyHook(ch);
                        listeners = cbs.remove.length + 1;
                        rm = createRmCb(ch.elm, listeners);
                        for (var i = 0; i < cbs.remove.length; ++i)
                            cbs.remove[i](ch, rm);
                        var removeHook = (_b = (_a = ch === null || ch === void 0 ? void 0 : ch.data) === null || _a === void 0 ? void 0 : _a.hook) === null || _b === void 0 ? void 0 : _b.remove;
                        if (isDef(removeHook)) {
                            removeHook(ch, rm);
                        }
                        else {
                            rm();
                        }
                    }
                    else {
                        api.removeChild(parentElm, ch.elm);
                    }
                }
            }
        }
        function updateChildren(parentElm, oldCh, newCh, insertedVnodeQueue) {
            var oldStartIdx = 0;
            var newStartIdx = 0;
            var oldEndIdx = oldCh.length - 1;
            var oldStartVnode = oldCh[0];
            var oldEndVnode = oldCh[oldEndIdx];
            var newEndIdx = newCh.length - 1;
            var newStartVnode = newCh[0];
            var newEndVnode = newCh[newEndIdx];
            var oldKeyToIdx;
            var idxInOld;
            var elmToMove;
            var before;
            while (oldStartIdx <= oldEndIdx && newStartIdx <= newEndIdx) {
                if (oldStartVnode == null) {
                    oldStartVnode = oldCh[++oldStartIdx];
                }
                else if (oldEndVnode == null) {
                    oldEndVnode = oldCh[--oldEndIdx];
                }
                else if (newStartVnode == null) {
                    newStartVnode = newCh[++newStartIdx];
                }
                else if (newEndVnode == null) {
                    newEndVnode = newCh[--newEndIdx];
                }
                else if (sameVnode(oldStartVnode, newStartVnode)) {
                    patchVnode(oldStartVnode, newStartVnode, insertedVnodeQueue);
                    oldStartVnode = oldCh[++oldStartIdx];
                    newStartVnode = newCh[++newStartIdx];
                }
                else if (sameVnode(oldEndVnode, newEndVnode)) {
                    patchVnode(oldEndVnode, newEndVnode, insertedVnodeQueue);
                    oldEndVnode = oldCh[--oldEndIdx];
                    newEndVnode = newCh[--newEndIdx];
                }
                else if (sameVnode(oldStartVnode, newEndVnode)) {
                    patchVnode(oldStartVnode, newEndVnode, insertedVnodeQueue);
                    api.insertBefore(parentElm, oldStartVnode.elm, api.nextSibling(oldEndVnode.elm));
                    oldStartVnode = oldCh[++oldStartIdx];
                    newEndVnode = newCh[--newEndIdx];
                }
                else if (sameVnode(oldEndVnode, newStartVnode)) {
                    patchVnode(oldEndVnode, newStartVnode, insertedVnodeQueue);
                    api.insertBefore(parentElm, oldEndVnode.elm, oldStartVnode.elm);
                    oldEndVnode = oldCh[--oldEndIdx];
                    newStartVnode = newCh[++newStartIdx];
                }
                else {
                    if (oldKeyToIdx === undefined) {
                        oldKeyToIdx = createKeyToOldIdx(oldCh, oldStartIdx, oldEndIdx);
                    }
                    idxInOld = oldKeyToIdx[newStartVnode.key];
                    if (isUndef(idxInOld)) {
                        api.insertBefore(parentElm, createElm(newStartVnode, insertedVnodeQueue), oldStartVnode.elm);
                    }
                    else {
                        elmToMove = oldCh[idxInOld];
                        if (elmToMove.sel !== newStartVnode.sel) {
                            api.insertBefore(parentElm, createElm(newStartVnode, insertedVnodeQueue), oldStartVnode.elm);
                        }
                        else {
                            patchVnode(elmToMove, newStartVnode, insertedVnodeQueue);
                            oldCh[idxInOld] = undefined;
                            api.insertBefore(parentElm, elmToMove.elm, oldStartVnode.elm);
                        }
                    }
                    newStartVnode = newCh[++newStartIdx];
                }
            }
            if (oldStartIdx <= oldEndIdx || newStartIdx <= newEndIdx) {
                if (oldStartIdx > oldEndIdx) {
                    before = newCh[newEndIdx + 1] == null ? null : newCh[newEndIdx + 1].elm;
                    addVnodes(parentElm, before, newCh, newStartIdx, newEndIdx, insertedVnodeQueue);
                }
                else {
                    removeVnodes(parentElm, oldCh, oldStartIdx, oldEndIdx);
                }
            }
        }
        function patchVnode(oldVnode, vnode, insertedVnodeQueue) {
            var _a, _b, _c, _d, _e;
            var hook = (_a = vnode.data) === null || _a === void 0 ? void 0 : _a.hook;
            (_b = hook === null || hook === void 0 ? void 0 : hook.prepatch) === null || _b === void 0 ? void 0 : _b.call(hook, oldVnode, vnode);
            var elm = (vnode.elm = oldVnode.elm);
            var oldCh = oldVnode.children;
            var ch = vnode.children;
            if (oldVnode === vnode)
                return;
            if (vnode.data !== undefined) {
                for (var i = 0; i < cbs.update.length; ++i)
                    cbs.update[i](oldVnode, vnode);
                (_d = (_c = vnode.data.hook) === null || _c === void 0 ? void 0 : _c.update) === null || _d === void 0 ? void 0 : _d.call(_c, oldVnode, vnode);
            }
            if (isUndef(vnode.text)) {
                if (isDef(oldCh) && isDef(ch)) {
                    if (oldCh !== ch)
                        updateChildren(elm, oldCh, ch, insertedVnodeQueue);
                }
                else if (isDef(ch)) {
                    if (isDef(oldVnode.text))
                        api.setTextContent(elm, "");
                    addVnodes(elm, null, ch, 0, ch.length - 1, insertedVnodeQueue);
                }
                else if (isDef(oldCh)) {
                    removeVnodes(elm, oldCh, 0, oldCh.length - 1);
                }
                else if (isDef(oldVnode.text)) {
                    api.setTextContent(elm, "");
                }
            }
            else if (oldVnode.text !== vnode.text) {
                if (isDef(oldCh)) {
                    removeVnodes(elm, oldCh, 0, oldCh.length - 1);
                }
                api.setTextContent(elm, vnode.text);
            }
            (_e = hook === null || hook === void 0 ? void 0 : hook.postpatch) === null || _e === void 0 ? void 0 : _e.call(hook, oldVnode, vnode);
        }
        return function patch(oldVnode, vnode) {
            var i, elm, parent;
            var insertedVnodeQueue = [];
            for (i = 0; i < cbs.pre.length; ++i)
                cbs.pre[i]();
            if (!isVnode(oldVnode)) {
                oldVnode = emptyNodeAt(oldVnode);
            }
            if (sameVnode(oldVnode, vnode)) {
                patchVnode(oldVnode, vnode, insertedVnodeQueue);
            }
            else {
                elm = oldVnode.elm;
                parent = api.parentNode(elm);
                createElm(vnode, insertedVnodeQueue);
                if (parent !== null) {
                    api.insertBefore(parent, vnode.elm, api.nextSibling(elm));
                    removeVnodes(parent, [oldVnode], 0, 0);
                }
            }
            for (i = 0; i < insertedVnodeQueue.length; ++i) {
                insertedVnodeQueue[i].data.hook.insert(insertedVnodeQueue[i]);
            }
            for (i = 0; i < cbs.post.length; ++i)
                cbs.post[i]();
            return vnode;
        };
    }
    exports.init = init;
});
define("is", ["require", "exports"], function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.primitive = exports.array = void 0;
    exports.array = Array.isArray;
    function primitive(s) {
        return typeof s === "string" ||
            typeof s === "number" ||
            s instanceof String ||
            s instanceof Number;
    }
    exports.primitive = primitive;
});
define("jsx", ["require", "exports", "./vnode", "./h"], function (require, exports, vnode_3, h_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.jsx = void 0;
    function flattenAndFilter(children, flattened) {
        for (var _i = 0, children_1 = children; _i < children_1.length; _i++) {
            var child = children_1[_i];
            if (child !== undefined &&
                child !== null &&
                child !== false &&
                child !== "") {
                if (Array.isArray(child)) {
                    flattenAndFilter(child, flattened);
                }
                else if (typeof child === "string" ||
                    typeof child === "number" ||
                    typeof child === "boolean") {
                    flattened.push((0, vnode_3.vnode)(undefined, undefined, undefined, String(child), undefined));
                }
                else {
                    flattened.push(child);
                }
            }
        }
        return flattened;
    }
    function jsx(tag, data) {
        var children = [];
        for (var _i = 2; _i < arguments.length; _i++) {
            children[_i - 2] = arguments[_i];
        }
        var flatChildren = flattenAndFilter(children, []);
        if (typeof tag === "function") {
            return tag(data, flatChildren);
        }
        else {
            if (flatChildren.length === 1 &&
                !flatChildren[0].sel &&
                flatChildren[0].text) {
                return (0, h_1.h)(tag, data, flatChildren[0].text);
            }
            else {
                return (0, h_1.h)(tag, data, flatChildren);
            }
        }
    }
    exports.jsx = jsx;
    (function (jsx) {
    })(jsx || (exports.jsx = jsx = {}));
});
define("snabbdom", ["require", "exports", "./htmldomapi", "./init", "./thunk", "./vnode", "./helpers/attachto", "./is", "./tovnode", "./h", "./hooks", "./modules/attributes", "./modules/class", "./modules/dataset", "./modules/eventlisteners", "./modules/props", "./modules/style", "./jsx"], function (require, exports, htmldomapi_2, init_2, thunk_1, vnode_4, attachto_1, is_1, tovnode_1, h_2, hooks_2, attributes_1, class_1, dataset_1, eventlisteners_1, props_1, style_1, jsx_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.jsx = exports.styleModule = exports.propsModule = exports.eventListenersModule = exports.datasetModule = exports.classModule = exports.attributesModule = exports.h = exports.toVNode = exports.primitive = exports.array = exports.attachTo = exports.vnode = exports.thunk = exports.init = exports.htmlDomApi = void 0;
    Object.defineProperty(exports, "htmlDomApi", { enumerable: true, get: function () { return htmldomapi_2.htmlDomApi; } });
    Object.defineProperty(exports, "init", { enumerable: true, get: function () { return init_2.init; } });
    Object.defineProperty(exports, "thunk", { enumerable: true, get: function () { return thunk_1.thunk; } });
    Object.defineProperty(exports, "vnode", { enumerable: true, get: function () { return vnode_4.vnode; } });
    Object.defineProperty(exports, "attachTo", { enumerable: true, get: function () { return attachto_1.attachTo; } });
    Object.defineProperty(exports, "array", { enumerable: true, get: function () { return is_1.array; } });
    Object.defineProperty(exports, "primitive", { enumerable: true, get: function () { return is_1.primitive; } });
    Object.defineProperty(exports, "toVNode", { enumerable: true, get: function () { return tovnode_1.toVNode; } });
    Object.defineProperty(exports, "h", { enumerable: true, get: function () { return h_2.h; } });
    __exportStar(hooks_2, exports);
    Object.defineProperty(exports, "attributesModule", { enumerable: true, get: function () { return attributes_1.attributesModule; } });
    Object.defineProperty(exports, "classModule", { enumerable: true, get: function () { return class_1.classModule; } });
    Object.defineProperty(exports, "datasetModule", { enumerable: true, get: function () { return dataset_1.datasetModule; } });
    Object.defineProperty(exports, "eventListenersModule", { enumerable: true, get: function () { return eventlisteners_1.eventListenersModule; } });
    Object.defineProperty(exports, "propsModule", { enumerable: true, get: function () { return props_1.propsModule; } });
    Object.defineProperty(exports, "styleModule", { enumerable: true, get: function () { return style_1.styleModule; } });
    Object.defineProperty(exports, "jsx", { enumerable: true, get: function () { return jsx_1.jsx; } });
});
define("thunk", ["require", "exports", "./h"], function (require, exports, h_3) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.thunk = void 0;
    function copyToThunk(vnode, thunk) {
        vnode.data.fn = thunk.data.fn;
        vnode.data.args = thunk.data.args;
        thunk.data = vnode.data;
        thunk.children = vnode.children;
        thunk.text = vnode.text;
        thunk.elm = vnode.elm;
    }
    function init(thunk) {
        var cur = thunk.data;
        var vnode = cur.fn.apply(cur, cur.args);
        copyToThunk(vnode, thunk);
    }
    function prepatch(oldVnode, thunk) {
        var i;
        var old = oldVnode.data;
        var cur = thunk.data;
        var oldArgs = old.args;
        var args = cur.args;
        if (old.fn !== cur.fn || oldArgs.length !== args.length) {
            copyToThunk(cur.fn.apply(cur, args), thunk);
            return;
        }
        for (i = 0; i < args.length; ++i) {
            if (oldArgs[i] !== args[i]) {
                copyToThunk(cur.fn.apply(cur, args), thunk);
                return;
            }
        }
        copyToThunk(oldVnode, thunk);
    }
    var thunk = function thunk(sel, key, fn, args) {
        if (args === undefined) {
            args = fn;
            fn = key;
            key = undefined;
        }
        return (0, h_3.h)(sel, {
            key: key,
            hook: { init: init, prepatch: prepatch },
            fn: fn,
            args: args,
        });
    };
    exports.thunk = thunk;
});
define("tovnode", ["require", "exports", "./vnode", "./htmldomapi"], function (require, exports, vnode_5, htmldomapi_3) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.toVNode = void 0;
    function toVNode(node, domApi) {
        var api = domApi !== undefined ? domApi : htmldomapi_3.htmlDomApi;
        var text;
        if (api.isElement(node)) {
            var id = node.id ? "#" + node.id : "";
            var cn = node.getAttribute("class");
            var c = cn ? "." + cn.split(" ").join(".") : "";
            var sel = api.tagName(node).toLowerCase() + id + c;
            var attrs = {};
            var children = [];
            var name_1;
            var i = void 0, n = void 0;
            var elmAttrs = node.attributes;
            var elmChildren = node.childNodes;
            for (i = 0, n = elmAttrs.length; i < n; i++) {
                name_1 = elmAttrs[i].nodeName;
                if (name_1 !== "id" && name_1 !== "class") {
                    attrs[name_1] = elmAttrs[i].nodeValue;
                }
            }
            for (i = 0, n = elmChildren.length; i < n; i++) {
                children.push(toVNode(elmChildren[i], domApi));
            }
            return (0, vnode_5.vnode)(sel, { attrs: attrs }, children, undefined, node);
        }
        else if (api.isText(node)) {
            text = api.getTextContent(node);
            return (0, vnode_5.vnode)(undefined, undefined, undefined, text, node);
        }
        else if (api.isComment(node)) {
            text = api.getTextContent(node);
            return (0, vnode_5.vnode)("!", {}, [], text, node);
        }
        else {
            return (0, vnode_5.vnode)("", {}, [], undefined, node);
        }
    }
    exports.toVNode = toVNode;
});
define("vnode", ["require", "exports"], function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.vnode = void 0;
    function vnode(sel, data, children, text, elm) {
        var key = data === undefined ? undefined : data.key;
        return { sel: sel, data: data, children: children, text: text, elm: elm, key: key };
    }
    exports.vnode = vnode;
});
define("helpers/attachto", ["require", "exports"], function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.attachTo = void 0;
    function pre(vnode, newVnode) {
        var attachData = vnode.data.attachData;
        newVnode.data.attachData.placeholder = attachData.placeholder;
        newVnode.data.attachData.real = attachData.real;
        vnode.elm = vnode.data.attachData.real;
    }
    function post(_, vnode) {
        vnode.elm = vnode.data.attachData.placeholder;
    }
    function destroy(vnode) {
        if (vnode.elm !== undefined) {
            vnode.elm.parentNode.removeChild(vnode.elm);
        }
        vnode.elm = vnode.data.attachData.real;
    }
    function create(_, vnode) {
        var real = vnode.elm;
        var attachData = vnode.data.attachData;
        var placeholder = document.createElement("span");
        vnode.elm = placeholder;
        attachData.target.appendChild(real);
        attachData.real = real;
        attachData.placeholder = placeholder;
    }
    function attachTo(target, vnode) {
        if (vnode.data === undefined)
            vnode.data = {};
        if (vnode.data.hook === undefined)
            vnode.data.hook = {};
        var data = vnode.data;
        var hook = vnode.data.hook;
        data.attachData = { target: target, placeholder: undefined, real: undefined };
        hook.create = create;
        hook.prepatch = pre;
        hook.postpatch = post;
        hook.destroy = destroy;
        return vnode;
    }
    exports.attachTo = attachTo;
});
define("modules/attributes", ["require", "exports"], function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.attributesModule = void 0;
    var xlinkNS = "http://www.w3.org/1999/xlink";
    var xmlNS = "http://www.w3.org/XML/1998/namespace";
    var colonChar = 58;
    var xChar = 120;
    function updateAttrs(oldVnode, vnode) {
        var key;
        var elm = vnode.elm;
        var oldAttrs = oldVnode.data.attrs;
        var attrs = vnode.data.attrs;
        if (!oldAttrs && !attrs)
            return;
        if (oldAttrs === attrs)
            return;
        oldAttrs = oldAttrs || {};
        attrs = attrs || {};
        for (key in attrs) {
            var cur = attrs[key];
            var old = oldAttrs[key];
            if (old !== cur) {
                if (cur === true) {
                    elm.setAttribute(key, "");
                }
                else if (cur === false) {
                    elm.removeAttribute(key);
                }
                else {
                    if (key.charCodeAt(0) !== xChar) {
                        elm.setAttribute(key, cur);
                    }
                    else if (key.charCodeAt(3) === colonChar) {
                        elm.setAttributeNS(xmlNS, key, cur);
                    }
                    else if (key.charCodeAt(5) === colonChar) {
                        elm.setAttributeNS(xlinkNS, key, cur);
                    }
                    else {
                        elm.setAttribute(key, cur);
                    }
                }
            }
        }
        for (key in oldAttrs) {
            if (!(key in attrs)) {
                elm.removeAttribute(key);
            }
        }
    }
    exports.attributesModule = {
        create: updateAttrs,
        update: updateAttrs,
    };
});
define("modules/class", ["require", "exports"], function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.classModule = void 0;
    function updateClass(oldVnode, vnode) {
        var cur;
        var name;
        var elm = vnode.elm;
        var oldClass = oldVnode.data.class;
        var klass = vnode.data.class;
        if (!oldClass && !klass)
            return;
        if (oldClass === klass)
            return;
        oldClass = oldClass || {};
        klass = klass || {};
        for (name in oldClass) {
            if (oldClass[name] && !Object.prototype.hasOwnProperty.call(klass, name)) {
                elm.classList.remove(name);
            }
        }
        for (name in klass) {
            cur = klass[name];
            if (cur !== oldClass[name]) {
                elm.classList[cur ? "add" : "remove"](name);
            }
        }
    }
    exports.classModule = { create: updateClass, update: updateClass };
});
define("modules/dataset", ["require", "exports"], function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.datasetModule = void 0;
    var CAPS_REGEX = /[A-Z]/g;
    function updateDataset(oldVnode, vnode) {
        var elm = vnode.elm;
        var oldDataset = oldVnode.data.dataset;
        var dataset = vnode.data.dataset;
        var key;
        if (!oldDataset && !dataset)
            return;
        if (oldDataset === dataset)
            return;
        oldDataset = oldDataset || {};
        dataset = dataset || {};
        var d = elm.dataset;
        for (key in oldDataset) {
            if (!dataset[key]) {
                if (d) {
                    if (key in d) {
                        delete d[key];
                    }
                }
                else {
                    elm.removeAttribute("data-" + key.replace(CAPS_REGEX, "-$&").toLowerCase());
                }
            }
        }
        for (key in dataset) {
            if (oldDataset[key] !== dataset[key]) {
                if (d) {
                    d[key] = dataset[key];
                }
                else {
                    elm.setAttribute("data-" + key.replace(CAPS_REGEX, "-$&").toLowerCase(), dataset[key]);
                }
            }
        }
    }
    exports.datasetModule = {
        create: updateDataset,
        update: updateDataset,
    };
});
define("modules/eventlisteners", ["require", "exports"], function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.eventListenersModule = void 0;
    function invokeHandler(handler, vnode, event) {
        if (typeof handler === "function") {
            handler.call(vnode, event, vnode);
        }
        else if (typeof handler === "object") {
            for (var i = 0; i < handler.length; i++) {
                invokeHandler(handler[i], vnode, event);
            }
        }
    }
    function handleEvent(event, vnode) {
        var name = event.type;
        var on = vnode.data.on;
        if (on && on[name]) {
            invokeHandler(on[name], vnode, event);
        }
    }
    function createListener() {
        return function handler(event) {
            handleEvent(event, handler.vnode);
        };
    }
    function updateEventListeners(oldVnode, vnode) {
        var oldOn = oldVnode.data.on;
        var oldListener = oldVnode.listener;
        var oldElm = oldVnode.elm;
        var on = vnode && vnode.data.on;
        var elm = (vnode && vnode.elm);
        var name;
        if (oldOn === on) {
            return;
        }
        if (oldOn && oldListener) {
            if (!on) {
                for (name in oldOn) {
                    oldElm.removeEventListener(name, oldListener, false);
                }
            }
            else {
                for (name in oldOn) {
                    if (!on[name]) {
                        oldElm.removeEventListener(name, oldListener, false);
                    }
                }
            }
        }
        if (on) {
            var listener = (vnode.listener =
                oldVnode.listener || createListener());
            listener.vnode = vnode;
            if (!oldOn) {
                for (name in on) {
                    elm.addEventListener(name, listener, false);
                }
            }
            else {
                for (name in on) {
                    if (!oldOn[name]) {
                        elm.addEventListener(name, listener, false);
                    }
                }
            }
        }
    }
    exports.eventListenersModule = {
        create: updateEventListeners,
        update: updateEventListeners,
        destroy: updateEventListeners,
    };
});
define("modules/module", ["require", "exports"], function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
});
define("modules/props", ["require", "exports"], function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.propsModule = void 0;
    function updateProps(oldVnode, vnode) {
        var key;
        var cur;
        var old;
        var elm = vnode.elm;
        var oldProps = oldVnode.data.props;
        var props = vnode.data.props;
        if (!oldProps && !props)
            return;
        if (oldProps === props)
            return;
        oldProps = oldProps || {};
        props = props || {};
        for (key in props) {
            cur = props[key];
            old = oldProps[key];
            if (old !== cur && (key !== "value" || elm[key] !== cur)) {
                elm[key] = cur;
            }
        }
    }
    exports.propsModule = { create: updateProps, update: updateProps };
});
define("modules/style", ["require", "exports"], function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.styleModule = void 0;
    var raf = (typeof window !== "undefined" &&
        window.requestAnimationFrame.bind(window)) ||
        setTimeout;
    var nextFrame = function (fn) {
        raf(function () {
            raf(fn);
        });
    };
    var reflowForced = false;
    function setNextFrame(obj, prop, val) {
        nextFrame(function () {
            obj[prop] = val;
        });
    }
    function updateStyle(oldVnode, vnode) {
        var cur;
        var name;
        var elm = vnode.elm;
        var oldStyle = oldVnode.data.style;
        var style = vnode.data.style;
        if (!oldStyle && !style)
            return;
        if (oldStyle === style)
            return;
        oldStyle = oldStyle || {};
        style = style || {};
        var oldHasDel = "delayed" in oldStyle;
        for (name in oldStyle) {
            if (!style[name]) {
                if (name[0] === "-" && name[1] === "-") {
                    elm.style.removeProperty(name);
                }
                else {
                    elm.style[name] = "";
                }
            }
        }
        for (name in style) {
            cur = style[name];
            if (name === "delayed" && style.delayed) {
                for (var name2 in style.delayed) {
                    cur = style.delayed[name2];
                    if (!oldHasDel || cur !== oldStyle.delayed[name2]) {
                        setNextFrame(elm.style, name2, cur);
                    }
                }
            }
            else if (name !== "remove" && cur !== oldStyle[name]) {
                if (name[0] === "-" && name[1] === "-") {
                    elm.style.setProperty(name, cur);
                }
                else {
                    elm.style[name] = cur;
                }
            }
        }
    }
    function applyDestroyStyle(vnode) {
        var style;
        var name;
        var elm = vnode.elm;
        var s = vnode.data.style;
        if (!s || !(style = s.destroy))
            return;
        for (name in style) {
            elm.style[name] = style[name];
        }
    }
    function applyRemoveStyle(vnode, rm) {
        var s = vnode.data.style;
        if (!s || !s.remove) {
            rm();
            return;
        }
        if (!reflowForced) {
            vnode.elm.offsetLeft;
            reflowForced = true;
        }
        var name;
        var elm = vnode.elm;
        var i = 0;
        var style = s.remove;
        var amount = 0;
        var applied = [];
        for (name in style) {
            applied.push(name);
            elm.style[name] = style[name];
        }
        var compStyle = getComputedStyle(elm);
        var props = compStyle["transition-property"].split(", ");
        for (; i < props.length; ++i) {
            if (applied.indexOf(props[i]) !== -1)
                amount++;
        }
        elm.addEventListener("transitionend", function (ev) {
            if (ev.target === elm)
                --amount;
            if (amount === 0)
                rm();
        });
    }
    function forceReflow() {
        reflowForced = false;
    }
    exports.styleModule = {
        pre: forceReflow,
        create: updateStyle,
        update: updateStyle,
        destroy: applyDestroyStyle,
        remove: applyRemoveStyle,
    };
});
define("public/describe", ["require", "exports"], function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
});
define("public/vdom", ["require", "exports", "snabbdom"], function (require, exports, snabbdom_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var patch = (0, snabbdom_1.init)([
        snabbdom_1.classModule,
        snabbdom_1.propsModule,
        snabbdom_1.styleModule,
        snabbdom_1.eventListenersModule,
    ]);
    var Vm = (function () {
        function Vm(config) {
            var _this = this;
            var el = config.el, template = config.template, methods = config.methods, mounted = config.mounted;
            this.$element = document.querySelector("".concat(el));
            this.$el = el;
            this.$methods = methods;
            this.$template = template;
            this.$mounted = mounted;
            this.$keys = {};
            this.$watcher({
                data: config.data,
                watch: function (key, oldVal, newVal) {
                    _this.$reanderElement(_this.$el);
                }
            });
            this.$eventHandle();
            this.$reanderElement(el);
        }
        Vm.prototype.$watcher = function (opts) {
            this._data = this.$getBaseType(opts.data) === 'Object' ? opts.data : {};
            this.$watch = opts.watch;
            for (var key in opts.data) {
                this.$setData(key);
            }
        };
        Vm.prototype.$getBaseType = function (target) {
            var typeStr = Object.prototype.toString.apply(target);
            return typeStr.slice(8, -1);
        };
        Vm.prototype.$reanderElement = function (el) {
            var _this = this;
            var jsxTemplate = (0, snabbdom_1.jsx)("div", { props: { id: el.replace('#', '') }, hook: {
                    insert: function (vnode) {
                        if (typeof _this.$VirtualDOM === "undefined")
                            _this.$mounted && _this.$mounted();
                    }
                } },
                " ",
                this.$template(this));
            this.$VirtualDOM = patch((typeof this.$VirtualDOM !== "undefined" ? this.$VirtualDOM : this.$element), jsxTemplate);
        };
        Vm.prototype.$setData = function (_key) {
            Object.defineProperty(this, _key, {
                get: function () {
                    return this._data[_key];
                },
                set: function (val) {
                    var oldVal = this._data[_key];
                    if (oldVal === val)
                        return val;
                    this._data[_key] = val;
                    this.$watch.call(this, _key, oldVal, val);
                    return val;
                },
            });
        };
        Vm.prototype.$eventHandle = function () {
            Object.assign(this, this.$methods);
            for (var key in this.$methods) {
                if (Object.prototype.hasOwnProperty.call(this.$methods, key)) {
                    this.$methods[key].bind(this);
                }
            }
        };
        Vm.prototype.$class = function (array) {
            if (typeof array === 'string')
                array = array.trim().split(' ');
            var classList = {};
            for (var i = 0; i < array.length; i++)
                classList[array[i]] = true;
            return classList;
        };
        Vm.prototype.$style = function (str) {
            if (!str)
                return {};
            if (typeof str === "object")
                return str;
            var style = {}, styleList = str.split(';');
            for (var i = 0; i < styleList.length; i++) {
                if (styleList[i] === '')
                    continue;
                var styleItem = styleList[i].split(':');
                style[styleItem[0].trim()] = styleItem[1];
            }
            return style;
        };
        Vm.prototype.$ul = function (config, arry) {
            if (Array.isArray(config)) {
                arry = config;
                config = { style: {}, className: '' };
            }
            var style = config.style, className = config.className;
            var liList = arry.map(function (item, index) {
                if (typeof (item) === 'string')
                    item = [item];
                return (0, snabbdom_1.jsx)("li", { key: index, style: { color: (item[1] || '') } }, item[0] || item);
            });
            return (0, snabbdom_1.jsx)("ul", { class: this.$class("help-info-text c7 ".concat(className || '')), style: this.$style(style) }, liList);
        };
        Vm.prototype.$line = function (config, content) {
            if (typeof config != "object")
                config = { title: config };
            var title = config.title, width = config.width, style = config.style, hide = config.hide;
            return (0, snabbdom_1.jsx)("div", { class: { "line": true, "hide": hide } },
                (0, snabbdom_1.jsx)("span", { class: { "tname": true }, style: this.$style("".concat(width ? ('width:' + width + ';') : '').concat(style)) }, title),
                (0, snabbdom_1.jsx)("div", { class: { "info-r": true }, style: { marginLeft: width } }, content));
        };
        Vm.prototype.$box = function (element1, element2) {
            return (0, snabbdom_1.jsx)("div", { class: this.$class('group-box') },
                " ",
                element1,
                " ",
                element2);
        };
        Vm.prototype.$switch = function (config) {
            var checked = config.checked, change = config.change, model = config.model, name = config.name;
            if (model)
                checked = this[model], name = model;
            return (0, snabbdom_1.jsx)("div", { class: { "info-block": true } },
                (0, snabbdom_1.jsx)("input", { class: this.$class('btswitch btswitch-ios'), props: { id: (model + '_vm'), type: "checkbox", name: name, checked: checked }, on: { input: this.$inputEvent.bind(this), change: change } }),
                (0, snabbdom_1.jsx)("label", { style: { position: "relative", top: "5px" }, class: { "btswitch-btn": true }, props: { htmlFor: (model + '_vm') } }));
        };
        Vm.prototype.$input = function (config) {
            var name = config.name, readonly = config.readonly, disabled = config.disabled, style = config.style, value = config.value, type = config.type, change = config.change, className = config.className, model = config.model, width = config.width, id = config.id, placeholder = config.placeholder, keyup = config.keyup;
            if (model)
                value = this[model], name = model;
            if (width)
                style = "width:".concat(width, ";").concat(style);
            return (0, snabbdom_1.jsx)("input", { class: this.$class("bt-input-text mr5 ".concat(className || '')), props: { readonly: readonly, name: name, type: type || "text", disabled: disabled, value: value, id: id, placeholder: placeholder }, style: this.$style(style), on: { input: this.$inputEvent.bind(this), change: change, keyup: keyup } });
        };
        Vm.prototype.$select = function (config) {
            var style = config.style, className = config.className, options = config.options, model = config.model, name = config.name, value = config.value, width = config.width, change = config.change;
            if (model)
                value = this[model], name = model;
            if (width)
                style = "width:".concat(width, ";").concat(style);
            var optionList = options.map(function (item, index) {
                if (typeof item === 'string')
                    item = { value: index, label: item };
                return (0, snabbdom_1.jsx)("option", { key: index, props: { value: item.value, selected: item.value === value } }, item.label);
            });
            return (0, snabbdom_1.jsx)("select", { class: this.$class("bt-input-text mr5 ".concat(className || '')), props: { name: name }, on: { input: this.$inputEvent.bind(this), change: change }, style: this.$style(style) }, optionList);
        };
        Vm.prototype.$textarea = function (config) {
            var style = config.style, className = config.className, value = config.value, model = config.model, name = config.name, width = config.width, height = config.height, id = config.id;
            if (model)
                value = this[model], name = model;
            if (width)
                style = "width:".concat(width, ";").concat(style);
            if (height)
                style = "height:".concat(height, ";").concat(style);
            return (0, snabbdom_1.jsx)("textarea", { class: this.$class("bt-input-text ".concat(className || '')), style: this.$style(style), props: { name: name, id: id }, on: { input: this.$inputEvent.bind(this) } }, value);
        };
        Vm.prototype.$button = function (config) {
            var type = config.type, size = config.size, click = config.click, style = config.style, className = config.className, title = config.title, width = config.width, height = config.height;
            if (width)
                style = "width:".concat(width, ";").concat(style);
            if (height)
                style = "height:".concat(height, ";").concat(style);
            return (0, snabbdom_1.jsx)("button", { class: this.$class("btn btn-".concat((type || 'success'), " btn-").concat((size || 'sm'), " ").concat((className || ''))), style: this.$style(style), on: { click: click } }, title);
        };
        Vm.prototype.$link = function (config) {
            var click = config.click, style = config.style, className = config.className, title = config.title, href = config.href, target = config.target;
            return (0, snabbdom_1.jsx)("a", { class: this.$class('btlink ' + className), props: { href: (href || 'javascript:;'), target: (target || '_blank') }, style: this.$style(style), on: { click: click } }, title);
        };
        Vm.prototype.$icon = function (config) {
            var click = config.click, style = config.style, type = config.type;
            return (0, snabbdom_1.jsx)("span", { class: this.$class("glyphicon glyphicon-".concat(type, " cursor")), style: this.$style(style), on: { click: click } });
        };
        Vm.prototype.$warningTitle = function (tips) {
            return (0, snabbdom_1.jsx)("div", { class: { 'mb15': true } },
                (0, snabbdom_1.jsx)("i", { class: this.$class('layui-layer-ico layui-layer-ico3 layer-info-ico') }),
                (0, snabbdom_1.jsx)("h3", { class: { 'layer-info-title': true } }, tips));
        };
        Vm.prototype.$learnMore = function (config) {
            var title = config.title, model = config.model, className = config.className, style = config.style, id = config.id, relation = model + '_more';
            return (0, snabbdom_1.jsx)("div", { class: this.$class("mt10 plr15 agreementBox ".concat(className || '')), props: { id: id }, style: this.$style(style) },
                this.$input({ type: 'checkbox', model: model, id: relation }),
                (0, snabbdom_1.jsx)("label", { props: { htmlFor: relation } }, title));
        };
        Vm.prototype.$table = function (config) {
            return (0, snabbdom_1.jsx)("div", { class: { "divtable": true } },
                (0, snabbdom_1.jsx)("table", { class: { "table table-bordered table-hover": true } }));
        };
        Vm.prototype.$tab = function (config) {
            var title = config.title, content = config.content, className = config.className, style = config.style, id = config.id;
            return (0, snabbdom_1.jsx)("div", { class: { "bt-w-main": true } },
                (0, snabbdom_1.jsx)("div", { class: { "bt-w-menu": true } }),
                (0, snabbdom_1.jsx)("div", { class: { "bt-w-con": true, "pd15": true } }, { content: content }));
        };
        Vm.prototype.$tabItem = function (config) {
            var title = config.title, content = config.content, hide = config.hide;
            return (0, snabbdom_1.jsx)("div", { class: { "bt-w-item": true, "hide": hide }, props: { title: title } }, content);
        };
        Vm.prototype.$inputEvent = function (ev, fn) {
            var targets = ev.target;
            var targetValue = targets.value;
            var targetType = targets.getAttribute('type');
            var name = targets.getAttribute('name');
            if (ev.type === 'input' && targetType === 'checkbox') {
                this[name] = targets.checked;
            }
            else {
                this[name] = targetValue;
            }
            if (typeof fn === 'function')
                fn(ev);
        };
        return Vm;
    }());
    exports.default = Vm;
});
define("public/utils", ["require", "exports", "public/vdom"], function (require, exports, vdom_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    vdom_1 = __importDefault(vdom_1);
    var Utils = (function () {
        function Utils() {
            this.System = 'linux';
            this.Language = 'zh-CN';
            this.API = {};
            this.vDdomList = {};
            this.layerIndex = 0;
            this.$requestInit();
        }
        Utils.prototype.$checkIp = function (ip) {
            var reg = /^(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])$/;
            return reg.test(ip);
        };
        Utils.prototype.$checkIps = function (ips) {
            var reg = /^\d{1, 3}\.\d{1, 3}\.\d{1, 3}\.\d{1, 3}(\/\d{1, 2})?$/;
            return reg.test(ips);
        };
        Utils.prototype.$checkDomainList = function (domainInfo) {
            if (typeof domainInfo === "string")
                domainInfo = domainInfo.split(",");
            var reg = /^([a-zA-Z0-9]([a-zA-Z0-9\-]{0, 61}[a-zA-Z0-9])?\.)+[a-zA-Z]{2, 6}$/;
            for (var _i = 0, domainInfo_1 = domainInfo; _i < domainInfo_1.length; _i++) {
                var item = domainInfo_1[_i];
                if (!reg.test(item))
                    return false;
            }
            return true;
        };
        Utils.prototype.$checkPawComplexity = function (paw) {
            var regList = {
                length: /^.{8,}$/,
                number: /\d+/,
                lowercase: /[a-z]+/,
                capital: /[A-Z]+/,
                special: /[^A-Za-z0-9]+/
            };
            return false;
        };
        Utils.prototype.$checkWeakCipher = function (paw) {
            var checks = ['admin888', '123123123', '12345678', '45678910', '87654321', 'asdfghjkl', 'password', 'qwerqwer'], pchecks = 'abcdefghijklmnopqrstuvwxyz1234567890', lower = paw.toLowerCase(), isError = '';
            for (var i = 0; i < pchecks.length; i++) {
                var item = pchecks[i];
                checks.push(item + item + item + item + item + item + item + item);
            }
            for (var i = 0; i < checks.length; i++) {
                var item = checks[i];
                if (lower === item)
                    isError += "[".concat(item, "]");
                break;
            }
            return {
                status: !isError,
                msg: isError
            };
        };
        Utils.prototype.$checkUrl = function (url) {
            var reg = /^((https|http|ftp|rtsp|mms)?:\/\/)[^\s]+/;
            return reg.test(url);
        };
        Utils.prototype.$checkPort = function (port) {
            var reg = /^([1-9]|[1-9]\d|[1-9]\d{2}|[1-9]\d{3}|[1-5]\d{4}|6[0-4]\d{3}|65[0-4]\d{2}|655[0-2]\d|6553[0-5])$/;
            return reg.test(port.toString());
        };
        Utils.prototype.$checkChinese = function (chinese) {
            var reg = /^[\u4e00-\u9fa5]+$/;
            return reg.test(chinese);
        };
        Utils.prototype.$checkDomain = function (domain) {
            domain = domain.toString();
            var reg = /^([\w\u4e00-\u9fa5\-\*]{1,100}\.){1,10}([\w\u4e00-\u9fa5\-]{1,24}|[\w\u4e00-\u9fa5\-]{1,24}\.[\w\u4e00-\u9fa5\-]{1,24})$/;
            return reg.test(domain.replace(/\s*/g, ""));
        };
        Utils.prototype.$checkEmail = function (email) {
            var reg = /^[a-zA-Z0-9_-]+@[a-zA-Z0-9_-]+(\.[a-zA-Z0-9_-]+)+$/;
            return reg.test(email);
        };
        Utils.prototype.$checkPhone = function (phone) {
            var reg = /^1[3456789]\d{9}$/;
            return reg.test(phone.toString());
        };
        Utils.prototype.$containsStr = function (str, subStr) {
            if (typeof str !== 'string' && typeof subStr !== 'string')
                return false;
            return str.indexOf(subStr) > -1;
        };
        Utils.prototype.$replaceTrim = function (str) {
            return str.replace(/\s+/g, "");
        };
        Utils.prototype.$ltrim = function (str, l) {
            var reg = new RegExp("/(^\\" + l + "+)/g");
            return str.replace(reg, "");
        };
        Utils.prototype.$rtrim = function (str, r) {
            var reg = new RegExp("/(\\" + r + "+$)/g");
            return str.replace(reg, "");
        };
        Utils.prototype.$formatTime = function (time, format) {
            if (format === void 0) { format = 'yyyy/MM/dd hh:mm:ss'; }
            var timestamp = '';
            if (typeof time === 'object')
                timestamp = time.getTime().toString();
            if (typeof time === 'string')
                timestamp = new Date(time).getTime().toString();
            if (typeof time === "number")
                timestamp = time.toString();
            if (timestamp.length > 10)
                timestamp = timestamp.substring(0, 10);
            var date = new Date(parseInt(timestamp) * 1000);
            var o = {
                "M+": date.getMonth() + 1,
                "d+": date.getDate(),
                "h+": date.getHours(),
                "m+": date.getMinutes(),
                "s+": date.getSeconds(),
                "q+": Math.floor((date.getMonth() + 3) / 3),
                "S": date.getMilliseconds()
            };
            if (/(y+)/.test(format))
                format = format.replace(RegExp.$1, (date.getFullYear() + "").substr(4 - RegExp.$1.length));
            for (var k in o) {
                if (new RegExp("(" + k + ")").test(format)) {
                    format = format.replace(RegExp.$1, RegExp.$1.length == 1 ? o[k] : ("00" + o[k]).substr(("" + o[k]).length));
                }
            }
            return format;
        };
        Utils.prototype.$formatSize = function (bytes, isUnit, fixed, endUnit) {
            if (bytes === void 0) { bytes = 0; }
            if (isUnit === void 0) { isUnit = true; }
            if (fixed === void 0) { fixed = 2; }
            if (endUnit === void 0) { endUnit = ''; }
            if (typeof bytes === 'string')
                bytes = parseInt(bytes);
            var unit = [' B', ' KB', ' MB', ' GB', 'TB'], c = 1024;
            for (var i = 0; i < unit.length; i++) {
                var cUnit = unit[i];
                var val = bytes;
                if (fixed !== 0 && i === 0)
                    val = bytes.toFixed(fixed);
                if (endUnit) {
                    if (cUnit.trim() == endUnit.trim()) {
                        if (endUnit) {
                            return val + cUnit;
                        }
                        else {
                            return val;
                        }
                    }
                }
                else {
                    if (bytes < c) {
                        if (isUnit) {
                            return val + cUnit;
                        }
                        else {
                            return val;
                        }
                    }
                }
                bytes /= c;
            }
        };
        Utils.prototype.$formatPath = function (path) {
            var reg = /(\\)/g;
            path = path.replace(reg, '/');
            return path;
        };
        Utils.prototype.$getFilePath = function (filename) {
            if (filename === '/')
                return '/';
            filename = (filename + '/').replace(/\/\//g, '/');
            var arr = filename.split('/'), last = arr[arr.length - 1];
            return filename.replace('/' + arr[arr.length - (last === '' ? 2 : 1)], "");
        };
        Utils.prototype.$getRandom = function (len) {
            if (len === void 0) { len = 32; }
            var $chars = 'AaBbCcDdEeFfGHhiJjKkLMmNnPpRSrTsWtXwYxZyz2345678', maxPos = $chars.length;
            var password = '';
            for (var i = 0; i < len; i++) {
                password += $chars.charAt(Math.floor(Math.random() * maxPos));
            }
            return password;
        };
        Utils.prototype.$getRandomNum = function (min, max) {
            if (min === void 0) { min = 0; }
            if (max === void 0) { max = 9; }
            return Math.floor(Math.random() * (max - min + 1) + min);
        };
        Utils.prototype.$getStorage = function (key) {
            return window.localStorage.getItem(key);
        };
        Utils.prototype.$setStorage = function (key, value) {
            window.localStorage.setItem(key, value);
        };
        Utils.prototype.$removeStorage = function (key) {
            window.localStorage.removeItem(key);
        };
        Utils.prototype.$getCookie = function (name) {
            var reg = new RegExp("(^| )" + name + "=([^;]*)(;|$)");
            var itExist = document.cookie.match(reg);
            if (itExist) {
                var val = unescape(itExist[2]);
                return val == 'undefined' ? '' : val;
            }
            else {
                return null;
            }
        };
        Utils.prototype.$setCookie = function (name, value, time) {
            if (time === void 0) { time = 2592000000; }
            var date = '', expires = new Date();
            expires.setTime(expires.getTime() + time);
            date = expires.toGMTString();
            var isHttps = window.location.protocol === 'https:';
            var sameSite = ';Secure; Path=/; SameSite=None';
            document.cookie = name + "=" + escape(value) + ";expires=" + time + (isHttps ? sameSite : '');
        };
        Utils.prototype.$removeCookie = function (name) {
            this.$setCookie(name, '', 0);
        };
        Utils.prototype.$requestInit = function () {
            var _this_1 = this;
            var requestTokenHead = document.getElementById("request_token_head");
            var headers = { 'x-http-token': '', 'x-cookie-token': '' };
            var httpToken = (requestTokenHead && requestTokenHead.getAttribute('token')) || '';
            var cookieToken = this.$getCookie('request_token') || '';
            httpToken && (headers['x-http-token'] = httpToken);
            cookieToken && (headers['x-cookie-token'] = cookieToken);
            if (httpToken && cookieToken) {
                $.ajaxSetup({
                    headers: headers,
                    error: function (XHR) { return __awaiter(_this_1, void 0, void 0, function () {
                        var resText, resStatus, monitorStr, content, errorHead, isErrorHead, errorBody, tmp;
                        return __generator(this, function (_a) {
                            switch (_a.label) {
                                case 0:
                                    resText = XHR.responseText, resStatus = XHR.status, monitorStr = ['/static/favicon.ico', '/static/img/qrCode.png', '<!DOCTYPE html>'], content = '';
                                    if (resText)
                                        return [2, false];
                                    if (typeof resText == 'string' && monitorStr.some(function (item) { return resText.indexOf(item) > -1; }))
                                        return [2, this.$refreshBrowser('/login')];
                                    errorHead = 'We need to make sure this has a favicon so that the debugger does', isErrorHead = resText.indexOf(errorHead) > -1;
                                    if (resStatus === 500 && resText.indexOf('运行时发生错误') > -1 && isErrorHead) {
                                        if (resText.indexOf('请先绑定宝塔帐号!') > -1) {
                                            this.$refreshBrowser("/bind?redirect=".concat(encodeURIComponent(window.location.href)));
                                            return [2, false];
                                        }
                                        if (isErrorHead) {
                                            errorBody = resText.split('<!--')[2].replace('-->', '');
                                            tmp = errorBody.split('During handling of the above exception, another exception occurred:');
                                            errorBody = tmp[tmp.length - 1];
                                            content = "<div>\n                <h3 style=\"margin-bottom: 10px;\">\u51FA\u9519\u4E86\uFF0C\u9762\u677F\u8FD0\u884C\u65F6\u53D1\u751F\u9519\u8BEF\uFF01</h3>\n                <pre style=\"height:635px;word-wrap: break-word;white-space: pre-wrap;margin: 0 0\">".concat(errorBody.trim(), "</pre>\n                <ul class=\"help-info-text\">\n                  <li style=\"list-style: none;\"><b>\u5F88\u62B1\u6B49\uFF0C\u9762\u677F\u8FD0\u884C\u65F6\u610F\u5916\u53D1\u751F\u9519\u8BEF\uFF0C\u8BF7\u5C1D\u8BD5\u6309\u4EE5\u4E0B\u987A\u5E8F\u5C1D\u8BD5\u89E3\u9664\u6B64\u9519\u8BEF\uFF1A</b></li>\n                  <li style=\"list-style: none;\">1\u3001\u5728[\u9996\u9875]\u53F3\u4E0A\u89D2\u70B9\u51FB\u4FEE\u590D\u9762\u677F\uFF0C\u5E76\u9000\u51FA\u9762\u677F\u91CD\u65B0\u767B\u5F55\u3002</li>\n                  <li style=\"list-style: none;\">2\u3001\u5982\u4E0A\u8FF0\u5C1D\u8BD5\u672A\u80FD\u89E3\u9664\u6B64\u9519\u8BEF\uFF0C\u8BF7\u622A\u56FE\u6B64\u7A97\u53E3\u5230\u5B9D\u5854\u8BBA\u575B\u53D1\u8D34\u5BFB\u6C42\u5E2E\u52A9, \u8BBA\u575B\u5730\u5740\uFF1A<a class=\"btlink\" href=\"https://www.bt.cn/bbs\" target=\"_blank\">https://www.bt.cn/bbs</a></li>                </ul>\n              </div>");
                                        }
                                        else {
                                            content = resText;
                                        }
                                    }
                                    return [4, this.$open({
                                            title: false,
                                            content: content,
                                            area: ["1200px", "810px"],
                                            btn: false
                                        })];
                                case 1:
                                    _a.sent();
                                    return [2];
                            }
                        });
                    }); }
                });
            }
        };
        Utils.prototype.$send = function (param, param1, param2) {
            var _this_1 = this;
            if (param2 === void 0) { param2 = ''; }
            return new Promise(function (resolve, reject) {
                var config = {
                    url: '',
                    method: 'POST',
                    msg: false,
                    data: {}
                }, loading = '', loadT;
                if (typeof param === "string") {
                    var urls = param.split('/');
                    config.url = "/".concat(urls[0], "?action=").concat(urls[1]);
                    if (typeof param1 === 'string') {
                        loading = param1;
                    }
                    else if (typeof param1 === "object") {
                        config.data = param1;
                        loading = param2;
                    }
                }
                else if (typeof param === "object") {
                    config.url = param.url;
                    config.method = param.method || 'POST';
                    config.msg = param.msg || false;
                    config.data = param.data || {};
                    loading = param.loading || '';
                }
                if (loading)
                    loadT = _this_1.$load("\u6B63\u5728".concat(loading, "\uFF0C\u8BF7\u7A0D\u540E..."));
                $.ajax({
                    url: config.url,
                    method: config.method,
                    data: config.data,
                    success: function (rdata) { return __awaiter(_this_1, void 0, void 0, function () {
                        return __generator(this, function (_a) {
                            switch (_a.label) {
                                case 0:
                                    if (loadT)
                                        loadT.close();
                                    if (!(typeof rdata === "object")) return [3, 3];
                                    if (!(typeof rdata.msg === 'string' && rdata.msg.indexOf('CSRF校验失败，请重新登录面板') > -1)) return [3, 2];
                                    return [4, this.$confirm({ title: '提示', msg: '面板登录已过期，请重新登录！' })];
                                case 1:
                                    _a.sent();
                                    layer.closeAll();
                                    this.$load('正在退出登录，请稍后...');
                                    this.$refreshBrowser('/login?dologin=True');
                                    return [2, false];
                                case 2:
                                    if (typeof rdata.msg === 'string' && rdata.msg === '没有权限' && !rdata.status) {
                                        layer.closeAll();
                                        this.$error(rdata.msg);
                                        return [2, false];
                                    }
                                    if (typeof rdata.status === "boolean" && !rdata.status && rdata.msg && config.msg)
                                        this.$error(rdata.msg);
                                    _a.label = 3;
                                case 3:
                                    resolve(rdata);
                                    return [2];
                            }
                        });
                    }); },
                    error: function (err) {
                        reject(err);
                    }
                });
            });
        };
        Utils.prototype.$apiInit = function (apiInfo) {
            this.API = Object.assign(this.API, apiInfo);
        };
        Utils.prototype.$request = function (info, param, config) {
            var _this_1 = this;
            if (param === void 0) { param = {}; }
            return new Promise(function (resolve, reject) { return __awaiter(_this_1, void 0, void 0, function () {
                var url, loading, rdata, error_1;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            if (typeof info === 'string')
                                info = this.API[info];
                            if (typeof param === 'boolean')
                                config = param, param = {};
                            if (typeof param === 'object' && param.hasOwnProperty('loading') && param.hasOwnProperty('msg'))
                                config = param, param = {};
                            if (typeof config === 'boolean')
                                config = { msg: config };
                            if (typeof config === 'undefined')
                                config = { msg: true, loading: true };
                            url = info[0], loading = info[1] || '';
                            if (!config.loading)
                                loading = '';
                            _a.label = 1;
                        case 1:
                            _a.trys.push([1, 3, , 4]);
                            return [4, this.$send(url, param, loading)];
                        case 2:
                            rdata = _a.sent();
                            config.msg && typeof rdata.msg === 'string' && this.$msg(rdata);
                            resolve(rdata);
                            return [3, 4];
                        case 3:
                            error_1 = _a.sent();
                            reject(error_1);
                            return [3, 4];
                        case 4: return [2];
                    }
                });
            }); });
        };
        Utils.prototype.$open = function (param) {
            var _this_1 = this;
            var _this = this;
            return new Promise(function (resolve, reject) {
                var id = "virtual-".concat(_this_1.$getRandom(5));
                var content = param.content, success = param.success, yes = param.yes, btn2 = param.btn2, cancel = param.cancel, title = param.title, shadeClose = param.shadeClose, closeBtn = param.closeBtn, skin = param.skin, type = param.type;
                var config = typeof param.content === 'string' ? '' : param.content;
                var vm;
                switch (typeof param.content) {
                    case 'string':
                        content = param.content;
                        break;
                    case 'object':
                        content = "<div id=\"".concat(id, "\"></div>");
                        break;
                }
                var layerConfig = {
                    title: title,
                    type: type || 1,
                    shadeClose: shadeClose,
                    content: content,
                    skin: skin,
                    closeBtn: closeBtn || 2,
                    success: function (layers, indexs) {
                        if (typeof config === 'object') {
                            var vm_1 = new vdom_1.default(Object.assign(config, { el: "#".concat(id) }));
                            vm_1['$closeLayer'] = function () {
                                layer.close(indexs);
                                return indexs;
                            };
                            _this.vDdomList[indexs] = vm_1;
                        }
                        success && success(layers, indexs, vm);
                    },
                    yes: function (indexs) {
                        _this.layerIndex = indexs;
                        var config = {
                            close: function () {
                                layer.close(indexs);
                                return indexs;
                            }, vm: _this.vDdomList[indexs]
                        };
                        yes && yes(config);
                        resolve(config);
                    },
                    cancel: function (indexs) {
                        _this.layerIndex = indexs;
                        if (cancel) {
                            cancel && cancel();
                        }
                        else {
                            reject({ cancel: true, type: 'cancel' });
                        }
                        delete _this.vDdomList[indexs];
                    },
                    btn2: function (indexs) {
                        _this.layerIndex = indexs;
                        if (btn2) {
                            btn2 && btn2();
                        }
                        else {
                            reject({ cancel: true, type: 'btn2' });
                        }
                        delete _this.vDdomList[indexs];
                    },
                    end: function () {
                        delete _this.vDdomList[_this.layerIndex];
                    }
                };
                layer.open(Object.assign(param, layerConfig));
            });
        };
        Utils.prototype.$confirm = function (param) {
            return new Promise(function (resolve, reject) {
                var msg = '';
                if (param.hasOwnProperty('msg')) {
                    msg = param.msg;
                    delete param.msg;
                }
                layer.confirm(msg, Object.assign({
                    title: '提示',
                    icon: 3,
                    btn: ['确定', '取消'],
                    shadeClose: false,
                    closeBtn: 2,
                    cancel: function () { return reject({ cancel: true }); }
                }, param), function (indexs) { return resolve(indexs); }, function () { return reject({ cancel: true }); });
            });
        };
        Utils.prototype.$tips = function (param) {
            var msg = '', el = '';
            if (param.msg) {
                msg = param.msg;
                delete param.msg;
            }
            if (param.el) {
                el = param.el;
                delete param.el;
            }
            return {
                layer: layer.tips(msg, el, Object.assign({ tips: [1, 'red'] }, param)),
                close: function () {
                    layer.close(this.layer);
                }
            };
        };
        Utils.prototype.$close = function (index) {
            layer.close(index);
        };
        Utils.prototype.$msg = function (param, param1) {
            var config = {
                time: 1500,
                shade: .3,
                shadeClose: true,
                closeBtn: 0,
                icon: 1,
            }, msg = '';
            if (typeof param === 'object') {
                for (var key in config) {
                    if (Object.prototype.hasOwnProperty.call(config, key)) {
                        if (typeof param[key] !== "undefined")
                            config[key] = param[key];
                    }
                }
                msg = param.msg + (param.msg_error || '') + (param.msg_solve || '');
                if (typeof msg == 'string' && typeof param.status === 'boolean') {
                    config.icon = typeof param.status === "boolean" ? (param.status ? 1 : 2) : 1;
                }
            }
            else if (typeof param === "string") {
                msg = param;
                if (typeof param1 === "boolean" || typeof param1 === "number") {
                    config.icon = typeof param1 === "boolean" ? (param1 ? 1 : 2) : param1;
                }
            }
            return {
                layer: layer.msg(msg, config),
                close: function () {
                    layer.close(this.layer);
                }
            };
        };
        Utils.prototype.$error = function (msg) {
            return this.$msg({ msg: msg, icon: 2 });
        };
        Utils.prototype.$warning = function (msg) {
            return this.$msg({ msg: msg, icon: 0 });
        };
        Utils.prototype.$load = function (tips) {
            if (tips === void 0) { tips = '正在处理, 请稍候...'; }
            return this.$msg({ msg: tips, icon: 16, time: 0, shade: [0.3, '#000'] });
        };
        Utils.prototype.$verifySubmit = function (param, msg) {
            var _this_1 = this;
            return new Promise(function (resolve) {
                var status = false;
                status = typeof param === 'function' ? param() : param;
                if (status) {
                    _this_1.$error(msg);
                }
                else {
                    resolve(status);
                }
            });
        };
        Utils.prototype.$verifySubmitList = function (list) {
            var _this_1 = this;
            return new Promise(function (resolve) { return __awaiter(_this_1, void 0, void 0, function () {
                var status, i, element;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            status = true;
                            i = 0;
                            _a.label = 1;
                        case 1:
                            if (!(i < list.length)) return [3, 4];
                            element = list[i];
                            return [4, this.$verifySubmit(element[0], element[1])];
                        case 2:
                            status = _a.sent();
                            if (status)
                                return [3, 4];
                            _a.label = 3;
                        case 3:
                            i++;
                            return [3, 1];
                        case 4:
                            if (!status)
                                resolve(true);
                            return [2];
                    }
                });
            }); });
        };
        Utils.prototype.$refreshBrowser = function (href, time) {
            if (href === void 0) { href = 1500; }
            if (time === void 0) { time = 1500; }
            typeof href === "number" && (time = href);
            return new Promise(function (resolve) {
                var clearId = setTimeout(function () {
                    switch (typeof href) {
                        case 'string':
                            location.href = href;
                            break;
                        case 'number':
                            location.reload();
                            break;
                    }
                    resolve && resolve(clearId);
                }, time);
            });
        };
        Utils.prototype.$require = function (moduleName) {
            return new Promise(function (resolve, reject) {
                try {
                    if (!Array.isArray(moduleName))
                        moduleName = [moduleName];
                    require(moduleName, function () {
                        var param = {};
                        for (var i = 0; i < arguments.length; i++) {
                            param[moduleName[i]] = arguments[i];
                        }
                        resolve(param);
                    });
                }
                catch (error) {
                    reject(error);
                }
            });
        };
        Utils.prototype.$delay = function (time) {
            if (time === void 0) { time = 1000; }
            return new Promise(function (resolve) {
                setTimeout(function () {
                    resolve(time);
                }, time);
            });
        };
        return Utils;
    }());
    exports.default = Utils;
});
define("public/public", ["require", "exports", "snabbdom", "public/utils"], function (require, exports, snabbdom_2, utils_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    utils_1 = __importDefault(utils_1);
    var Public = (function (_super) {
        __extends(Public, _super);
        function Public() {
            var _this_1 = _super.call(this) || this;
            _this_1.apiInfo = {
                'getUserInfo': ['ssl/GetUserInfo', '获取绑定账号信息'],
                'unbindUserInfo': ['ssl/DelToken', '解绑宝塔账号'],
                'restartPanel': ['system/ReWeb', '重启面板'],
                'GetAuthToken': ['ssl/GetAuthToken', '绑定宝塔账号'],
                'GetBindCode': ['ssl/GetBindCode', '获取验证码'],
                'getFileDir': ['files/GetDir', '获取文件目录'],
                'getMsgConfig': ['config/get_settings', '获取消息通道配置'],
                'setDingTalkConfig': ['config/set_dingding', '设置钉钉/企业微信推送配置'],
                'addMailAddress': ['config/add_mail_address', '添加收件人邮箱'],
                'delMailAddress': ['config/del_mail_list', '删除收件人邮箱'],
                'getMailList': ['config/get_settings', '获取邮件信息列表'],
                'setMailConfig': ['config/user_mail_send', '设置邮箱推送配置']
            };
            _this_1.$apiInit(_this_1.apiInfo);
            return _this_1;
        }
        Public.prototype.bindBtAccount = function () {
            return __awaiter(this, void 0, void 0, function () {
                var that_1, error_2;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            _a.trys.push([0, 2, , 3]);
                            that_1 = this;
                            return [4, this.$open({
                                    title: '绑定宝塔账号',
                                    area: '420px',
                                    content: {
                                        data: {
                                            username: '',
                                            password: '',
                                            token: '',
                                            verifyCode: '',
                                            tipsText: '获取验证码',
                                            verifyStatus: false,
                                            verifyBtnDisabled: false,
                                            usernameBtnDisabled: false,
                                            passwordBtnDisabled: false,
                                            clearIntervalVal: null
                                        },
                                        template: function () {
                                            return (0, snabbdom_2.jsx)("div", { class: this.$class('pd20 bt-form libLogin') },
                                                (0, snabbdom_2.jsx)("h4", { class: this.$class('c2 f18 text-center mtb20') },
                                                    "\u7ED1\u5B9A\u5B9D\u5854\u5B98\u7F51\u8D26\u53F7",
                                                    (0, snabbdom_2.jsx)("a", { props: { href: "javascript:;" }, class: this.$class("bind_ps bt-ico-ask") }, "?")),
                                                (0, snabbdom_2.jsx)("div", { class: { "line": true } }, this.$input({ model: 'username', placeholder: '手机', disabled: this.usernameBtnDisabled })),
                                                (0, snabbdom_2.jsx)("div", { class: { "line": true } }, this.$input({ model: 'password', type: 'password', placeholder: '密码', keyup: this.bindUserInfo.bind(this), disabled: this.usernameBtnDisabled })),
                                                (0, snabbdom_2.jsx)("div", { class: { "line": true, "verifyCodeView": true }, style: { display: this.verifyStatus ? 'block' : 'none' } },
                                                    this.$input({ model: 'verifyCode', placeholder: '验证码', keyup: this.bindUserInfo.bind(this) }),
                                                    (0, snabbdom_2.jsx)("div", { class: { "pull-right": true } },
                                                        (0, snabbdom_2.jsx)("span", { class: { "getVerifyCode": true, "active": this.verifyBtnDisabled }, style: { top: '5px' }, on: { click: this.cutVerifyViewStatus.bind(this) } }, this.tipsText))),
                                                (0, snabbdom_2.jsx)("div", { class: { "line": true } }, this.$button({ className: 'login-button', title: '绑定账号', click: this.bindUserInfo.bind(this), width: '360px', height: '40px' })),
                                                (0, snabbdom_2.jsx)("p", { class: { 'text-right': true } },
                                                    " ",
                                                    this.$link({ title: '未有账号，去注册', href: 'https://www.bt.cn/register.html' })));
                                        },
                                        methods: {
                                            bindUserInfo: function (ev) {
                                                return __awaiter(this, void 0, void 0, function () {
                                                    var _a, username, password, param, rdata;
                                                    return __generator(this, function (_b) {
                                                        switch (_b.label) {
                                                            case 0:
                                                                if (ev.type === 'keyup' && ev.keyCode !== 13)
                                                                    return [2, false];
                                                                _a = this, username = _a.username, password = _a.password;
                                                                return [4, that_1.$verifySubmitList([[!that_1.$checkPhone(username), '请输入手机号'], [!password, '请输入密码']])];
                                                            case 1:
                                                                _b.sent();
                                                                return [4, that_1.$verifySubmit(this.verifyStatus && !this.verifyCode, '请输入验证码')];
                                                            case 2:
                                                                _b.sent();
                                                                param = { username: username, password: password };
                                                                if (this.verifyStatus) {
                                                                    param['code'] = this.verifyCode;
                                                                    param['token'] = this.token;
                                                                }
                                                                return [4, that_1.$request('GetAuthToken', param, { msg: false })];
                                                            case 3:
                                                                rdata = _b.sent();
                                                                if (!rdata.status) return [3, 5];
                                                                that_1.$msg(rdata);
                                                                return [4, that_1.$refreshBrowser()];
                                                            case 4:
                                                                _b.sent();
                                                                return [2];
                                                            case 5:
                                                                if (typeof rdata.data == "undefined")
                                                                    return [2, false];
                                                                if (!rdata.status && JSON.stringify(rdata.data) === '[]')
                                                                    that_1.$msg(rdata);
                                                                if (!(rdata.data.code === -1)) return [3, 7];
                                                                layer.msg(rdata.msg);
                                                                this.token = rdata.data.token;
                                                                this.verifyStatus = true;
                                                                return [4, this.cutVerifyViewStatus()];
                                                            case 6:
                                                                _b.sent();
                                                                _b.label = 7;
                                                            case 7: return [2];
                                                        }
                                                    });
                                                });
                                            },
                                            cutVerifyViewStatus: function () {
                                                return __awaiter(this, void 0, void 0, function () {
                                                    return __generator(this, function (_a) {
                                                        switch (_a.label) {
                                                            case 0:
                                                                if (this.verifyBtnDisabled) {
                                                                    this.$error('验证码已发送，请稍后再试');
                                                                    return [2, false];
                                                                }
                                                                this.usernameBtnDisabled = true;
                                                                this.passwordBtnDisabled = true;
                                                                this.verifyBtnDisabled = true;
                                                                return [4, that_1.$request('GetBindCode', { username: this.username, token: this.token })];
                                                            case 1:
                                                                _a.sent();
                                                                return [4, this.countDown(60)];
                                                            case 2:
                                                                _a.sent();
                                                                return [2];
                                                        }
                                                    });
                                                });
                                            },
                                            countDown: function (time) {
                                                var _this_1 = this;
                                                if (this.clearIntervalVal)
                                                    clearInterval(this.clearIntervalVal);
                                                this.clearIntervalVal = setInterval(function () {
                                                    time--;
                                                    if (time <= 0) {
                                                        clearInterval(_this_1.clearIntervalVal);
                                                        _this_1.tipsText = '获取验证码';
                                                        _this_1.verifyBtnDisabled = false;
                                                        return;
                                                    }
                                                    _this_1.verifyBtnDisabled = true;
                                                    _this_1.tipsText = "\u91CD\u65B0\u53D1\u9001(".concat(time, "s)");
                                                }, 1000);
                                            }
                                        }
                                    },
                                    success: function () {
                                        var times = 0;
                                        $('.bind_ps').hover(function () {
                                            var _that = $(this);
                                            times = setTimeout(function () {
                                                layer.tips('宝塔面板许多功能都依赖于官网，绑定仅限于为您提供更好的面板服务体验，不涉及您服务器任何敏感信息，请放心使用。', _that, { tips: [1, '#20a53a'], time: 0 });
                                            }, 500);
                                        }, function () {
                                            clearTimeout(times);
                                            layer.closeAll('tips');
                                        });
                                    }
                                })];
                        case 1:
                            _a.sent();
                            return [3, 3];
                        case 2:
                            error_2 = _a.sent();
                            return [3, 3];
                        case 3: return [2];
                    }
                });
            });
        };
        Public.prototype.selectFileDir = function (id, type, success, default_path) {
            if (type === void 0) { type = 'all'; }
            return __awaiter(this, void 0, void 0, function () {
                var error_3;
                var _this_1 = this;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            this.$setCookie("SetName", "");
                            if (typeof type !== 'string')
                                success = type, type = 'dir';
                            _a.label = 1;
                        case 1:
                            _a.trys.push([1, 3, , 4]);
                            return [4, this.$open({
                                    area: "650px",
                                    title: type === 'all' ? '选择目录和文件' : type === 'file' ? lan.bt.file : lan.bt.dir,
                                    closeBtn: 2,
                                    content: "<div class='changepath'><div class='path-top'><button type='button' id='btn_back' class='btn btn-default btn-sm'><span class='glyphicon glyphicon-share-alt'></span> " + lan['public']['return'] + "</button><div class='place' id='PathPlace'>" + lan.bt.path + "：<span></span></div></div><div class='path-con'><div class='path-con-left'><dl><dt id='changecomlist' ></dt></dl></div><div class='path-con-right'><ul class='default' id='computerDefautl'></ul><div class='file-list divtable'><table class='table table-hover' style='border:0 none'><thead><tr class='file-list-head'><th width='5%'></th><th width='38%'>" + lan.bt.filename + "</th><th width='24%'>" + lan.bt.etime + "</th><th width='8%'>" + lan.bt.access + "</th><th width='15%'>" + lan.bt.own + "</th></tr></thead><tbody id='tbody' class='list-list'></tbody></table></div></div></div></div><div class='getfile-btn' style='margin-top:0'><button type='button' class='btn btn-default btn-sm pull-left' onclick='CreateFolder()'>" + lan.bt.adddir + "</button><button type='button' class='btn btn-danger btn-sm mr5 closeLayer'>" + lan['public'].close + "</button> <button type='button' id='bt_select' class='btn btn-success btn-sm' >" + lan.bt.path_ok + "</button></div>",
                                    success: function (layers, indexs) {
                                        var el = null;
                                        if (id.indexOf('.') === 0)
                                            el = $("." + id);
                                        if (id.indexOf('#') === 0)
                                            el = $("#" + id);
                                        if (id.indexOf('.') !== 0 && id.indexOf('#') !== 0)
                                            el = $(id);
                                        $('#btn_back').on('click', function () {
                                            var path = $("#PathPlace").find("span").text();
                                            path = _this_1.$rtrim(_this_1.$formatPath(path), '/');
                                            _this_1.getFileList(_this_1.$getFilePath(path), type);
                                        });
                                        $('#bt_select').on('click', function () {
                                            var path = _this_1.$formatPath($("#PathPlace").find("span").text());
                                            if (type === 'file' && !$('#tbody tr.active').length) {
                                                layer.msg('请选择文件后继续操作！', { icon: 0 });
                                                return false;
                                            }
                                            if ($('#tbody tr').hasClass('active'))
                                                path = $('#tbody tr.active .bt_open_dir').attr('path');
                                            path = _this_1.$rtrim(path, '/');
                                            el.val(path).trigger('input');
                                            success && success(path);
                                            layer.close(indexs);
                                        });
                                        $('.closeLayer').on('click', function () {
                                            layer.close(indexs);
                                        });
                                        _this_1.getFileList(el.val() || '/www/wwwroot', type);
                                    }
                                })];
                        case 2:
                            _a.sent();
                            return [3, 4];
                        case 3:
                            error_3 = _a.sent();
                            return [3, 4];
                        case 4: return [2];
                    }
                });
            });
        };
        Public.prototype.getFileList = function (path, type) {
            if (type === void 0) { type = 'dir'; }
            return __awaiter(this, void 0, void 0, function () {
                var _this, diskHtml, fileHtml, dirHtml, rdata, fileList, dirList, diskList, i_1, item, i_2, item, unfoldList, dirName, i, item, unfoldList, fileName;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            _this = this, diskHtml = '', fileHtml = '', dirHtml = '';
                            return [4, this.$request('getFileDir', { path: path, disk: true })];
                        case 1:
                            rdata = _a.sent();
                            fileList = rdata.FILES, dirList = rdata.DIR, diskList = rdata.DISK;
                            for (i_1 = 0; i_1 < diskList.length; i_1++) {
                                item = diskList[i_1];
                                diskHtml += "<dd class=\"bt_open_dir\" path =\"" + item.path + "\"><span class='glyphicon glyphicon-hdd'></span>&nbsp;" + item.path + "</dd>";
                            }
                            for (i_2 = 0; i_2 < dirList.length; i_2++) {
                                item = dirList[i_2], unfoldList = item.split(";");
                                dirName = unfoldList[0];
                                if (dirName.length > 20)
                                    dirName = dirName.substring(0, 20) + "...";
                                if (this.$checkChinese(dirName) && dirName.length > 10)
                                    dirName = dirName.substring(0, 10) + "...";
                                dirHtml += "<tr><td>" + ((type === 'all' || type === 'dir') ? '<input type=\"checkbox\" />' : '') + "</td><td class=\"bt_open_dir\" path =\"" + rdata.PATH + "/" + unfoldList[0] + "\" data-type=\"dir\" title='" + unfoldList[0] + "'><span class='glyphicon glyphicon-folder-open'></span><span>" + dirName + "</span></td><td>" + this.$formatTime(parseInt(unfoldList[2])) + "</td><td>" + unfoldList[3] + "</td><td>" + unfoldList[4] + "</td></tr>";
                            }
                            for (i = 0; i < fileList.length; i++) {
                                item = fileList[i], unfoldList = item.split(";");
                                fileName = unfoldList[0];
                                if (fileName.length > 20)
                                    fileName = fileName.substring(0, 20) + "...";
                                if (this.$checkChinese(fileName) && fileName.length > 10)
                                    fileName = fileName.substring(0, 10) + "...";
                                fileHtml += "<tr><td>" + ((type === 'all' || type === 'file') ? '<input type=\"checkbox\" />' : '') + "<td class=\"bt_open_dir\" title='" + unfoldList[0] + "' data-type=\"files\" path =\"" + rdata.PATH + "/" + unfoldList[0] + "\"><span class='glyphicon glyphicon-file'></span><span>" + fileName + "</span></td><td>" + this.$formatTime(parseInt(unfoldList[2])) + "</td><td>" + unfoldList[3] + "</td><td>" + unfoldList[4] + "</td></tr>";
                            }
                            $("#changecomlist").html(diskHtml);
                            $(".default").hide();
                            $(".file-list").show();
                            $("#tbody").html(dirHtml + fileHtml);
                            if (rdata.PATH.substr(rdata.PATH.length - 1, 1) != "/") {
                                rdata.PATH += "/";
                            }
                            $("#PathPlace").find("span").html(rdata.PATH);
                            $("#tbody tr").click(function () {
                                if ($(this).find('td:eq(0) input').length > 0) {
                                    if ($(this).hasClass('active')) {
                                        $(this).removeClass('active');
                                        $(this).find('td:eq(0) input').prop('checked', false);
                                    }
                                    else {
                                        $(this).find('td:eq(0) input').prop('checked', true);
                                        $(this).siblings().find('td:eq(0) input').prop('checked', false);
                                        $(this).addClass('active').siblings().removeClass('active');
                                    }
                                }
                            });
                            $('#changecomlist dd').click(function () {
                                _this.getFileList($(this).attr('path'), type);
                            });
                            $('.bt_open_dir span').click(function () {
                                if ($(this).parent().data('type') == 'dir')
                                    _this.getFileList($(this).parent().attr('path'), type);
                            });
                            return [2];
                    }
                });
            });
        };
        Public.prototype.setMessageChannelView = function (config, type) {
            if (type === void 0) { type = 0; }
            return __awaiter(this, void 0, void 0, function () {
                var rdata, _a, isAtAll, dingding_url, error_4;
                var _this_1 = this;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0: return [4, this.$request('getMsgConfig')];
                        case 1:
                            rdata = _b.sent(), _a = rdata.dingding.info.msg, isAtAll = _a.isAtAll, dingding_url = _a.dingding_url;
                            _b.label = 2;
                        case 2:
                            _b.trys.push([2, 4, , 5]);
                            return [4, this.$open({
                                    area: "600px",
                                    title: "设置消息通道",
                                    skin: "layer-channel-auth",
                                    content: "<div class=\"bt-form\">\n          <div class=\"bt-w-main\" style=\"height:460px\">\n            <div class=\"bt-w-menu\" style=\"width: 120px;\">\n              <p class=\"".concat(type === 0 ? 'bgw' : '', "\">\u90AE\u7BB1</p>\n              <p class=\"").concat(type === 1 ? 'bgw' : '', "\">\u9489\u9489/\u4F01\u4E1A\u5FAE\u4FE1</p>\n            </div>\n            <div class=\"bt-w-con pd15\" style=\"margin-left: 120px;\">\n              <div class=\"plugin_body\">\n                <div class=\"conter_box ").concat(type === 0 ? 'active' : 'hide', "\">\n                  <div class=\"bt-form\">\n                    <div class=\"line\">\n                      <button class=\"btn btn-success btn-sm addRecipient\">\u6DFB\u52A0\u6536\u4EF6\u8005</button>\n                      <button class=\"btn btn-default btn-sm setMailMessageView\">\u53D1\u9001\u8005\u8BBE\u7F6E</button>\n                    </div>\n                    <div class=\"line\">\n                      <div class=\"divtable\">\n                        <table id=\"receive_table\" class=\"table table-hover\">\n                          <thead>\n                            <tr>\n                              <th>\u90AE\u7BB1</th>\n                              <th class=\"text-right\" width=\"80px\">\u64CD\u4F5C</th>\n                            </tr>\n                          </thead>\n                          <tbody></tbody>\n                        </table>\n                      </div>\n                    </div>\n                  </div>\n                </div>\n                <div class=\"conter_box ").concat(type === 1 ? 'active' : 'hide', "\">\n                  <div class=\"bt-form\">\n                    <div class=\"line\">\n                      <span class=\"tname\">\u901A\u77E5\u5168\u4F53</span>\n                      <div class=\"info-r\" style=\"height:28px; margin-left:100px\">\n                        <input class=\"btswitch btswitch-ios\" id=\"panel_alert_all\" type=\"checkbox\" ").concat(isAtAll === 'True' ? 'checked' : '', ">\n                        <label style=\"position: relative;top: 5px;\" class=\"btswitch-btn\" for=\"panel_alert_all\"></label>\n                      </div>\n                    </div>\n                    <div class=\"line\">\n                      <span class=\"tname\">URL</span>\n                      <div class=\"info-r\"><textarea name=\"channel_dingding_value\" class=\"bt-input-text mr5\" type=\"text\" style=\"width: 300px; height:90px; line-height:20px\">").concat(dingding_url ? dingding_url : '', "</textarea></div>\n                      <button class=\"btn btn-success btn-sm setChannelDing ml5\" style=\"margin: 10px 0 0 100px;\">\u4FDD\u5B58</button>").concat(dingding_url ? '<button class="btn btn-default ml5 btn-sm delding">清除设置</button>' : '', "\n                    </div>                  </div>                  <ul class=\"help-info-text c7\" style=\"margin-top: 170px;\">                    <li>\u5F53\u524D\u652F\u6301\u9489\u9489\u3001\u4F01\u4E1A\u5FAE\u4FE1URL</li>                    <li style=\"list-style:inside disc\"><a class=\"btlink\" href=\"https://www.bt.cn/bbs/thread-71298-1-1.html\" target=\"_blank\">\u300A\u5982\u4F55\u8BBE\u7F6E\u6D88\u606F\u901A\u9053\u300B</a></li>                  </ul>                </div>              </div>            </div>          </div>          </div>"),
                                    success: function () {
                                        $('.addRecipient').on('click', function () { return _this_1.addMessageMail(); });
                                        $('.setMailMessageView').on('click', function () { return _this_1.setMailMessageView(config); });
                                        $('#receive_table').on('click', '.del_email', function (ev) { return __awaiter(_this_1, void 0, void 0, function () {
                                            var email, err_1;
                                            return __generator(this, function (_a) {
                                                switch (_a.label) {
                                                    case 0:
                                                        _a.trys.push([0, 4, , 5]);
                                                        email = $(ev.target).data('mail');
                                                        return [4, this.$confirm({ title: "\u5220\u9664\u90AE\u7BB1\u3010".concat(email, "\u3011"), msg: '是否删除该邮箱?' })];
                                                    case 1:
                                                        _a.sent();
                                                        return [4, this.removeEmail(email)];
                                                    case 2:
                                                        _a.sent();
                                                        return [4, this.$delay()];
                                                    case 3:
                                                        _a.sent();
                                                        this.renderMailMessageList();
                                                        return [3, 5];
                                                    case 4:
                                                        err_1 = _a.sent();
                                                        return [3, 5];
                                                    case 5:
                                                        ;
                                                        return [2];
                                                }
                                            });
                                        }); });
                                        $('.delding').click(function () { return __awaiter(_this_1, void 0, void 0, function () {
                                            var loadTs, err_2;
                                            var _this_1 = this;
                                            return __generator(this, function (_a) {
                                                switch (_a.label) {
                                                    case 0:
                                                        _a.trys.push([0, 2, , 3]);
                                                        return [4, this.$confirm({ title: '清除设置', msg: '是否清除设置?' })];
                                                    case 1:
                                                        _a.sent();
                                                        loadTs = layer.msg('正在清除设置中,请稍候...', {
                                                            icon: 16,
                                                            time: 0,
                                                            shade: [0.3, '#000']
                                                        });
                                                        $.post('/config?action=set_empty', {
                                                            type: 'dingding'
                                                        }, function (rdata) {
                                                            layer.close(loadTs);
                                                            layer.msg(rdata.msg, {
                                                                icon: rdata.status ? 1 : 2
                                                            });
                                                            if (!rdata.status)
                                                                return;
                                                            $('textarea[name=channel_dingding_value]').val('');
                                                            $('.delding').hide();
                                                            config.message_channel_info.dingding.dingding = false;
                                                            _this_1.renderChannelLine(config);
                                                            _this_1.renderLoginAlarmLine(config);
                                                        });
                                                        return [3, 3];
                                                    case 2:
                                                        err_2 = _a.sent();
                                                        return [3, 3];
                                                    case 3: return [2];
                                                }
                                            });
                                        }); });
                                        $(".bt-w-menu p").click(function () {
                                            var index = $(this).index();
                                            $(this).addClass('bgw').siblings().removeClass('bgw');
                                            $('.conter_box').eq(index).removeClass('hide').siblings().addClass('hide');
                                        });
                                        $(".setChannelDing").on('click', function () { return __awaiter(_this_1, void 0, void 0, function () {
                                            var url, atall, res;
                                            return __generator(this, function (_a) {
                                                switch (_a.label) {
                                                    case 0:
                                                        url = $('textarea[name=channel_dingding_value]').val();
                                                        atall = $('#panel_alert_all').prop("checked") ? 1 : 0;
                                                        return [4, this.$verifySubmit(!url, '请输入钉钉URL或企业微信URL')];
                                                    case 1:
                                                        _a.sent();
                                                        return [4, this.$request('setDingTalkConfig', { url: url, atall: atall })];
                                                    case 2:
                                                        res = _a.sent();
                                                        if (!res.status)
                                                            return [2];
                                                        $('.delding').show();
                                                        config.message_channel_info.dingding.dingding = true;
                                                        this.renderChannelLine(config);
                                                        this.renderLoginAlarmLine(config);
                                                        return [2];
                                                }
                                            });
                                        }); });
                                        _this_1.renderMailMessageList();
                                    }
                                })];
                        case 3:
                            _b.sent();
                            return [3, 5];
                        case 4:
                            error_4 = _b.sent();
                            return [3, 5];
                        case 5: return [2];
                    }
                });
            });
        };
        Public.prototype.renderChannelLine = function (config) {
            var mailMessage = $('.setMessageChannelMail');
            var nailNailMessage = $('.setMessageChannelNailNail');
            var message_channel_info = config.message_channel_info;
            var email = message_channel_info.user_mail.user_name, dingding = message_channel_info.dingding.dingding;
            if (email) {
                mailMessage.text('邮箱已设置').removeClass('bt_warning').addClass('btlink');
            }
            else {
                mailMessage.text('邮箱未设置').removeClass('btlink').addClass('bt_warning');
            }
            if (dingding) {
                nailNailMessage.text('钉钉/企业微信已设置').removeClass('bt_warning').addClass('btlink');
            }
            else {
                nailNailMessage.text('钉钉/企业微信未设置').removeClass('btlink').addClass('bt_warning');
            }
        };
        Public.prototype.renderLoginAlarmLine = function (config) {
            var setAlarmMail = $('.setAlarmMail');
            var setAlarmNailNail = $('.setAlarmNailNail');
            var interval = $('.interval');
            var login_alarm_info = config.login_alarm_info, message_channel_info = config.message_channel_info;
            var isSetEmail = login_alarm_info.mail, isSetdingding = login_alarm_info.dingding;
            var email = message_channel_info.user_mail.user_name, dingding = message_channel_info.dingding.dingding;
            var isChannel = email || dingding;
            if (isChannel && isSetEmail) {
                setAlarmMail.show().text('邮箱已设置').removeClass('bt_warning').addClass('btlink');
                interval.hide();
                setAlarmNailNail.hide();
            }
            else if (isChannel && isSetdingding) {
                setAlarmNailNail.show().text('钉钉/企业微信已设置').removeClass('bt_warning').addClass('btlink');
                interval.hide();
                setAlarmMail.hide();
            }
            else {
                interval.show();
                setAlarmMail.show();
                setAlarmNailNail.show();
                setAlarmMail.text('邮箱未设置').removeClass('btlink').addClass('bt_warning');
                setAlarmNailNail.text('钉钉/企业微信未设置').removeClass('btlink').addClass('bt_warning');
            }
        };
        Public.prototype.addMessageMail = function () {
            return __awaiter(this, void 0, void 0, function () {
                var error_5;
                var _this_1 = this;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            _a.trys.push([0, 2, , 3]);
                            return [4, this.$open({
                                    area: "400px",
                                    title: "添加收件者邮箱",
                                    btn: ['添加', '关闭'],
                                    content: "<div class=\"bt-form pd20\">\n            <div class=\"line\">\n              <span class=\"tname\">\u6536\u4EF6\u8005\u90AE\u7BB1</span>\n              <div class=\"info-r\">\n                <input name=\"creater_email_value\" class=\"bt-input-text mr5\" type=\"text\" style=\"width: 240px\" value=\"\">\n              </div>\n            </div>\n          </div>",
                                    yes: function (config) { return __awaiter(_this_1, void 0, void 0, function () {
                                        var email, rdata;
                                        return __generator(this, function (_a) {
                                            switch (_a.label) {
                                                case 0:
                                                    email = $('input[name=creater_email_value]').val();
                                                    return [4, this.$verifySubmit(!this.$checkEmail(email), '收件者邮箱格式错误')];
                                                case 1:
                                                    _a.sent();
                                                    return [4, this.$request('addMailAddress', { email: email })];
                                                case 2:
                                                    rdata = _a.sent();
                                                    rdata.status && config.close();
                                                    return [4, this.$delay()];
                                                case 3:
                                                    _a.sent();
                                                    this.renderMailMessageList();
                                                    return [2];
                                            }
                                        });
                                    }); }
                                })];
                        case 1:
                            _a.sent();
                            return [3, 3];
                        case 2:
                            error_5 = _a.sent();
                            return [3, 3];
                        case 3: return [2];
                    }
                });
            });
        };
        Public.prototype.removeEmail = function (email) {
            return __awaiter(this, void 0, void 0, function () {
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0: return [4, this.$request('delMailAddress', { email: email })];
                        case 1:
                            _a.sent();
                            return [2];
                    }
                });
            });
        };
        Public.prototype.setMailMessageView = function (config) {
            return __awaiter(this, void 0, void 0, function () {
                var rdata, _a, qq_mail, qq_stmp_pwd, hosts, port, verifyPortList, _that_1, error_6;
                var _this_1 = this;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0: return [4, this.$request('getMsgConfig')];
                        case 1:
                            rdata = _b.sent();
                            _a = rdata.user_mail.info.msg, qq_mail = _a.qq_mail, qq_stmp_pwd = _a.qq_stmp_pwd, hosts = _a.hosts, port = _a.port;
                            port = port || '';
                            verifyPortList = ['25', '465', '587', ''];
                            _b.label = 2;
                        case 2:
                            _b.trys.push([2, 4, , 5]);
                            _that_1 = this;
                            return [4, this.$open({
                                    title: '设置发送者邮箱信息',
                                    area: "460px",
                                    content: "<div class=\"bt-form pd20 pb70\">\n          <div class=\"line\">\n            <span class=\"tname\">\u53D1\u9001\u4EBA\u90AE\u7BB1</span>\n            <div class=\"info-r\"><input name=\"channel_email_value\" class=\"bt-input-text mr5\" type=\"text\" style=\"width: 300px\" value=\"".concat(qq_mail || '', "\"></div>\n          </div>\n          <div class=\"line\">\n            <span class=\"tname\">smtp\u5BC6\u7801</span>\n            <div class=\"info-r\"><input name=\"channel_email_password\" class=\"bt-input-text mr5\" type=\"password\" style=\"width: 300px\" value=\"").concat(qq_stmp_pwd || '', "\"></div>\n          </div>\n          <div class=\"line\">\n            <span class=\"tname\">smtp\u670D\u52A1\u5668</span>\n            <div class=\"info-r\"><input name=\"channel_email_server\" class=\"bt-input-text mr5\" type=\"text\" style=\"width: 300px\" value=\"").concat(hosts || '', "\"></div>\n          </div>\n          <div class=\"line\">\n            <span class=\"tname\">\u7AEF\u53E3</span>\n            <div class=\"info-r\">\n              <select class=\"bt-input-text mr5\" id=\"port_select\" style=\"width:").concat((verifyPortList.indexOf(port) > -1 ? '300px' : '100px'), "\">\n                <option value=\"465\" ").concat(port === '465' || port === '' ? 'selected' : '', ">465</option>\n                <option value=\"25\" ").concat(port === '25' ? 'selected' : '', ">25</option>\n                <option value=\"587\" ").concat(port === '587' ? 'selected' : '', ">587</option>\n                <option value=\"other\" ").concat(verifyPortList.indexOf(port) > -1 ? '' : 'selected', ">\u81EA\u5B9A\u4E49</option>\n              </select>\n              <input name=\"channel_email_port\" class=\"bt-input-text\" type=\"Number\" style=\"display:").concat((verifyPortList.indexOf(port) > -1 ? 'none' : 'inline-block'), ";width: 192px\" value=\"").concat(port || '', "\">\n            </div>\n          </div>\n          <ul class=\"help-info-text c7\">\n            <li>\u63A8\u8350\u4F7F\u7528465\u7AEF\u53E3\uFF0C\u534F\u8BAE\u4E3ASSL/TLS</li>\n            <li>25\u7AEF\u53E3\u4E3ASMTP\u534F\u8BAE\uFF0C587\u7AEF\u53E3\u4E3ASTARTTLS\u534F\u8BAE</li>\n          </ul>\n          <div class=\"bt-form-submit-btn\">").concat((qq_mail ? '<button type="button" class="btn btn-default btn-sm pull-left set_empty">清除设置</button>' : ''), "\n            <button type=\"button\" class=\"btn btn-danger btn-sm smtp_closeBtn\">\u5173\u95ED</button>\n            <button class=\"btn btn-success btn-sm SetChannelEmail\">\u4FDD\u5B58</button></div>\n        </div>"),
                                    success: function (layers, indexs) {
                                        var portSelect = $('#port_select'), mailPort = $('input[name=channel_email_port]');
                                        portSelect.change(function (ev) {
                                            var that = $(ev.target), mailPort = $('input[name=channel_email_port]');
                                            that.css("width", ev.target.value === 'other' ? "100px" : "300px");
                                            mailPort.css("display", ev.target.value === 'other' ? "inline-block" : "none");
                                        });
                                        $(".SetChannelEmail").click(function () { return __awaiter(_this_1, void 0, void 0, function () {
                                            var email, stmp_pwd, hosts, port, portSelectVal, rdata_1, err_3;
                                            return __generator(this, function (_a) {
                                                switch (_a.label) {
                                                    case 0:
                                                        email = $('input[name="channel_email_value"]').val();
                                                        stmp_pwd = $('input[name="channel_email_password"]').val();
                                                        hosts = $('input[name="channel_email_server"]').val();
                                                        port = '', portSelectVal = portSelect.val();
                                                        port = portSelectVal === 'other' ? mailPort.val() : portSelectVal;
                                                        _a.label = 1;
                                                    case 1:
                                                        _a.trys.push([1, 5, , 6]);
                                                        return [4, _that_1.$verifySubmitList([
                                                                [!email, '邮箱地址不能为空'],
                                                                [!stmp_pwd, 'STMP密码密码不能为空'],
                                                                [!hosts, 'STMP服务器地址不能为空'],
                                                                [!port, '邮箱端口不能为空'],
                                                                [!_that_1.$checkPort(port), '邮箱地址格式不正确']
                                                            ])];
                                                    case 2:
                                                        _a.sent();
                                                        return [4, _that_1.$request('setMailConfig', { email: email, stmp_pwd: stmp_pwd, hosts: hosts, port: port })];
                                                    case 3:
                                                        rdata_1 = _a.sent();
                                                        if (!rdata_1.status)
                                                            return [2];
                                                        this.$msg(rdata_1);
                                                        config.message_channel_info.user_mail.user_name = true;
                                                        this.renderChannelLine(config);
                                                        this.renderLoginAlarmLine(config);
                                                        return [4, this.$delay()];
                                                    case 4:
                                                        _a.sent();
                                                        layer.close(indexs);
                                                        this.renderMailMessageList();
                                                        return [3, 6];
                                                    case 5:
                                                        err_3 = _a.sent();
                                                        return [3, 6];
                                                    case 6:
                                                        ;
                                                        return [2];
                                                }
                                            });
                                        }); });
                                        $(".smtp_closeBtn").click(function () { return layer.close(indexs); });
                                        $('.set_empty').click(function () { return __awaiter(_this_1, void 0, void 0, function () {
                                            var rdata_2, err_4;
                                            return __generator(this, function (_a) {
                                                switch (_a.label) {
                                                    case 0:
                                                        _a.trys.push([0, 3, , 4]);
                                                        return [4, this.$confirm({ title: '提示', msg: '是否清空发送者邮箱?' })];
                                                    case 1:
                                                        _a.sent();
                                                        return [4, _that_1.$request(['config/set_empty', '清空邮箱发送者设置'], { type: 'mail' })];
                                                    case 2:
                                                        rdata_2 = _a.sent();
                                                        if (!rdata_2.status)
                                                            return [2];
                                                        layer.close(indexs);
                                                        config.message_channel_info.user_mail.user_name = false;
                                                        this.renderChannelLine(config);
                                                        this.renderLoginAlarmLine(config);
                                                        return [3, 4];
                                                    case 3:
                                                        err_4 = _a.sent();
                                                        return [3, 4];
                                                    case 4:
                                                        ;
                                                        return [2];
                                                }
                                            });
                                        }); });
                                    }
                                })];
                        case 3:
                            _b.sent();
                            return [3, 5];
                        case 4:
                            error_6 = _b.sent();
                            return [3, 5];
                        case 5: return [2];
                    }
                });
            });
        };
        Public.prototype.renderMailMessageList = function () {
            return __awaiter(this, void 0, void 0, function () {
                var rdata, _html, _list, i, item;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0: return [4, this.$request('getMailList', { loading: true, msg: false })];
                        case 1:
                            rdata = _a.sent();
                            _html = '', _list = rdata.user_mail.mail_list;
                            if (_list.length > 0) {
                                for (i = 0; i < _list.length; i++) {
                                    item = _list[i];
                                    _html += "<tr><td>".concat(item, "</td><td width=\"80px\" style=\"text-align:right;\"><a class=\"btlink del_email\" data-mail=\"").concat(item, "\" href=\"javascript:;\" style=\"color:#20a53a\">\u5220\u9664</a></td></tr>");
                                }
                            }
                            else {
                                _html = '<tr><td class="text-center" colspan="2">暂无数据</td></tr>';
                            }
                            $('#receive_table tbody').html(_html);
                            return [2];
                    }
                });
            });
        };
        return Public;
    }(utils_1.default));
    exports.default = Public;
});
